/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.routing.outbound.SplitMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class MessageSplitterRouterTestCase
extends AbstractMuleTestCase {
    public void testMessageSplitterRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getService", (Object)MessageSplitterRouterTestCase.getTestService());
        OutboundEndpoint endpoint1 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1Endpoint", "test://endpointUri.1");
        OutboundEndpoint endpoint2 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2");
        OutboundEndpoint endpoint3 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        OutboundEndpoint endpoint4 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test4Endpoint", "test://endpointUri.4?synchronous=true");
        OutboundEndpoint endpoint5 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test5Endpoint", "test://endpointUri.5?synchronous=true");
        OutboundEndpoint endpoint6 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test6Endpoint", "test://endpointUri.6?synchronous=true");
        AbstractMessageSplitter router = new AbstractMessageSplitter(){

            protected SplitMessage getMessageParts(MuleMessage message, List endpoints) {
                int i = 0;
                SplitMessage splitMessage = new SplitMessage();
                StringTokenizer tokenizer = new StringTokenizer(message.getPayload().toString(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    splitMessage.addPart((Object)s, (OutboundEndpoint)endpoints.get(i));
                    ++i;
                }
                return splitMessage;
            }
        };
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add(endpoint1);
        endpoints.add(endpoint2);
        endpoints.add(endpoint3);
        router.setEndpoints(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test,mule,message");
        MessageSplitterRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint2)));
        session.expect("dispatchEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint3)));
        router.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
        endpoints = new ArrayList();
        endpoints.add(endpoint4);
        endpoints.add(endpoint5);
        endpoints.add(endpoint6);
        router.getEndpoints().clear();
        router.setEndpoints(endpoints);
        message = new DefaultMuleMessage((Object)"test,mule,message");
        session.expectAndReturn("sendEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint4)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint5)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)C.isA(MuleMessage.class), (Constraint)C.eq((Object)endpoint6)), (Object)message);
        MuleMessage result = router.route((MuleMessage)message, (MuleSession)session.proxy());
        MessageSplitterRouterTestCase.assertNotNull((Object)result);
        MessageSplitterRouterTestCase.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MessageSplitterRouterTestCase.assertEquals((int)3, (int)((MuleMessageCollection)result).size());
        session.verify();
    }
}

