/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.FilterInputStream;
import java.io.IOException;
import java.util.List;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.SerializableToByteArray;

public class TransformerWeightingTestCase
extends AbstractMuleTestCase {
    public void testExactMatch() throws Exception {
        DummyTransformer trans = new DummyTransformer();
        trans.setReturnClass(byte[].class);
        trans.registerSourceType(IOException.class);
        TransformerWeighting weighting = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans);
        TransformerWeightingTestCase.assertFalse((boolean)weighting.isNotMatch());
        TransformerWeightingTestCase.assertTrue((boolean)weighting.isExactMatch());
    }

    public void testNearMatch() throws Exception {
        ObjectToByteArray trans = new ObjectToByteArray();
        TransformerWeighting weighting = new TransformerWeighting(FilterInputStream.class, byte[].class, (Transformer)trans);
        TransformerWeightingTestCase.assertFalse((boolean)weighting.isNotMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting.isExactMatch());
        TransformerWeightingTestCase.assertEquals((int)1, (int)weighting.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting.getOutputWeighting());
    }

    public void testNoMatchWeighting() throws Exception {
        SerializableToByteArray trans = new SerializableToByteArray();
        TransformerWeighting weighting = new TransformerWeighting(FruitBowl.class, byte[].class, (Transformer)trans);
        TransformerWeightingTestCase.assertTrue((boolean)weighting.isNotMatch());
        TransformerWeightingTestCase.assertEquals((int)-1, (int)weighting.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting.getOutputWeighting());
    }

    public void testCompareWeightingWithNearMatches() throws Exception {
        ObjectToByteArray trans1 = new ObjectToByteArray();
        DummyTransformer trans2 = new DummyTransformer();
        trans2.setReturnClass(byte[].class);
        trans2.registerSourceType(Exception.class);
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        TransformerWeightingTestCase.assertFalse((boolean)weighting1.isNotMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting2.isNotMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting1.isExactMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting2.isExactMatch());
        TransformerWeightingTestCase.assertEquals((int)1, (int)weighting2.compareTo((Object)weighting1));
        TransformerWeightingTestCase.assertEquals((int)2, (int)weighting1.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)1, (int)weighting2.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting1.getOutputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting2.getOutputWeighting());
    }

    public void testCompareWeightingWithExactMatch() throws Exception {
        ObjectToByteArray trans1 = new ObjectToByteArray();
        DummyTransformer trans2 = new DummyTransformer();
        trans2.setReturnClass(byte[].class);
        trans2.registerSourceType(IOException.class);
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        TransformerWeightingTestCase.assertFalse((boolean)weighting1.isNotMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting2.isNotMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting1.isExactMatch());
        TransformerWeightingTestCase.assertTrue((boolean)weighting2.isExactMatch());
        TransformerWeightingTestCase.assertEquals((int)1, (int)weighting2.compareTo((Object)weighting1));
        TransformerWeightingTestCase.assertEquals((int)2, (int)weighting1.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting2.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting1.getOutputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting2.getOutputWeighting());
    }

    public void testCompareWeightingWithNoMatch() throws Exception {
        ObjectToByteArray trans1 = new ObjectToByteArray();
        DummyTransformer trans2 = new DummyTransformer();
        trans2.setReturnClass(byte[].class);
        trans2.registerSourceType(FruitBowl.class);
        TransformerWeighting weighting1 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans1);
        TransformerWeighting weighting2 = new TransformerWeighting(IOException.class, byte[].class, (Transformer)trans2);
        TransformerWeightingTestCase.assertFalse((boolean)weighting1.isNotMatch());
        TransformerWeightingTestCase.assertTrue((boolean)weighting2.isNotMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting1.isExactMatch());
        TransformerWeightingTestCase.assertFalse((boolean)weighting2.isExactMatch());
        TransformerWeightingTestCase.assertEquals((int)-1, (int)weighting2.compareTo((Object)weighting1));
        TransformerWeightingTestCase.assertEquals((int)2, (int)weighting1.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)-1, (int)weighting2.getInputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting1.getOutputWeighting());
        TransformerWeightingTestCase.assertEquals((int)0, (int)weighting2.getOutputWeighting());
    }

    public void testPriorityMatching() throws Exception {
        DummyTransformer t1 = new DummyTransformer();
        t1.setName("--t1");
        t1.registerSourceType(Orange.class);
        t1.setReturnClass(Fruit.class);
        muleContext.getRegistry().registerTransformer((Transformer)t1);
        DummyTransformer t2 = new DummyTransformer();
        t2.setName("--t2");
        t2.registerSourceType(Object.class);
        t2.setReturnClass(Fruit.class);
        muleContext.getRegistry().registerTransformer((Transformer)t2);
        List trans = muleContext.getRegistry().lookupTransformers(BloodOrange.class, Fruit.class);
        TransformerWeightingTestCase.assertEquals((int)2, (int)trans.size());
        for (Transformer transformer : trans) {
            TransformerWeightingTestCase.assertTrue((boolean)transformer.getName().startsWith("--"));
        }
        Transformer result = muleContext.getRegistry().lookupTransformer(BloodOrange.class, Fruit.class);
        TransformerWeightingTestCase.assertNotNull((Object)result);
        TransformerWeightingTestCase.assertEquals((String)"--t1", (String)result.getName());
    }

    private class DummyTransformer
    extends AbstractTransformer
    implements DiscoverableTransformer {
        private int weighting;

        private DummyTransformer() {
        }

        public int getPriorityWeighting() {
            return this.weighting;
        }

        public void setPriorityWeighting(int weighting) {
            this.weighting = weighting;
        }

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            return src;
        }
    }
}

