/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan;

import java.util.Set;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.BloodOrange;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.OrangeInterface;
import org.mule.tck.testmodels.fruit.RedApple;
import org.mule.util.scan.ClasspathScanner;
import org.mule.util.scan.Grape;
import org.mule.util.scan.MadridOrange;
import org.mule.util.scan.SeedlessGrape;
import org.mule.util.scan.SubscribeBean;
import org.mule.util.scan.annotations.Marker;
import org.mule.util.scan.annotations.Meta;
import org.mule.util.scan.annotations.NonMeta;
import org.mule.util.scan.annotations.SampleBeanWithAnnotations;
import org.mule.util.scan.annotations.SampleClassWithAnnotations;

public class ClasspathScannerTestCase
extends AbstractMuleTestCase {
    public void testInterfaceScanClasspathAndJars() throws Exception {
        ClasspathScanner s = new ClasspathScanner(new String[]{"org"});
        Set set = s.scanFor(Fruit.class);
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(Apple.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(RedApple.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(BloodOrange.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(OrangeInterface.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(Orange.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(Grape.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SeedlessGrape.class));
    }

    public void testInterfaceScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner s = new ClasspathScanner(new String[]{"org/mule"});
        Set set = s.scanFor(Fruit.class);
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(Apple.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(RedApple.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(BloodOrange.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(OrangeInterface.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(Orange.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(Grape.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SeedlessGrape.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(MadridOrange.class));
    }

    public void testImplementationScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner s = new ClasspathScanner(new String[]{"org/mule"});
        Set set = s.scanFor(Orange.class);
        ClasspathScannerTestCase.assertFalse((boolean)set.contains(Apple.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(BloodOrange.class));
        ClasspathScannerTestCase.assertFalse((boolean)set.contains(OrangeInterface.class));
        ClasspathScannerTestCase.assertFalse((boolean)set.contains(Orange.class));
        ClasspathScannerTestCase.assertFalse((boolean)set.contains(Grape.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(MadridOrange.class));
    }

    public void testAnnotationMetaScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner s = new ClasspathScanner(new String[]{"org/mule/util"});
        Set set = s.scanFor(Meta.class);
        ClasspathScannerTestCase.assertEquals((int)3, (int)set.size());
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SampleClassWithAnnotations.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SampleBeanWithAnnotations.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SubscribeBean.class));
    }

    public void testAnnotationScanClasspathAndJarsMultipleBasePaths() throws Exception {
        ClasspathScanner s = new ClasspathScanner(new String[]{"org/mule"});
        Set set = s.scanFor(Marker.class);
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SampleBeanWithAnnotations.class));
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SubscribeBean.class));
        set = s.scanFor(NonMeta.class);
        ClasspathScannerTestCase.assertTrue((boolean)set.contains(SampleBeanWithAnnotations.class));
    }
}

