/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.scan.annotations;

import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.mule.util.scan.annotations.AnnotationInfo;
import org.mule.util.scan.annotations.AnnotationsScanner;
import org.mule.util.scan.annotations.Marker;
import org.mule.util.scan.annotations.MultiMarker;
import org.mule.util.scan.annotations.SampleClassWithAnnotations;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class AnnotationsScannerTestCase
extends TestCase {
    protected AnnotationsScanner scanner;

    protected void setUp() throws IOException {
        ClassReader r = new ClassReader(SampleClassWithAnnotations.class.getName());
        this.scanner = new AnnotationsScanner();
        r.accept((ClassVisitor)this.scanner, 0);
    }

    public void testParamAnnotations() throws Exception {
        List paramAnnotations = this.scanner.getParamAnnotations();
        System.out.println("Parameter annotations: " + paramAnnotations);
        AnnotationsScannerTestCase.assertNotNull((Object)paramAnnotations);
        AnnotationsScannerTestCase.assertEquals((int)2, (int)paramAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)paramAnnotations.get(0);
        AnnotationsScannerTestCase.assertEquals((String)Marker.class.getName(), (String)ann.getClassName());
        List annValues = ann.getParams();
        AnnotationsScannerTestCase.assertNotNull((Object)annValues);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)annValues.size());
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"ParamLevel"), annValues.get(0));
        ann = (AnnotationInfo)paramAnnotations.get(1);
        AnnotationsScannerTestCase.assertEquals((String)MultiMarker.class.getName(), (String)ann.getClassName());
        annValues = ann.getParams();
        AnnotationsScannerTestCase.assertNotNull((Object)annValues);
        AnnotationsScannerTestCase.assertEquals((int)3, (int)annValues.size());
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"ParamLevel"), annValues.get(0));
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("param1", (Object)"12"), annValues.get(1));
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("param2", (Object)"abc"), annValues.get(2));
    }

    public void testFieldAnnotations() throws Exception {
        List fieldAnnotations = this.scanner.getFieldAnnotations();
        System.out.println("Field annotations: " + fieldAnnotations);
        AnnotationsScannerTestCase.assertNotNull((Object)fieldAnnotations);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)fieldAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)fieldAnnotations.get(0);
        AnnotationsScannerTestCase.assertEquals((String)Marker.class.getName(), (String)ann.getClassName());
        List annValues = ann.getParams();
        AnnotationsScannerTestCase.assertNotNull((Object)annValues);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)annValues.size());
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"FieldLevel"), annValues.get(0));
    }

    public void testClassAnnotations() throws Exception {
        List classAnnotations = this.scanner.getClassAnnotations();
        System.out.println("Class annotations: " + classAnnotations);
        AnnotationsScannerTestCase.assertNotNull((Object)classAnnotations);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)classAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)classAnnotations.get(0);
        AnnotationsScannerTestCase.assertEquals((String)Marker.class.getName(), (String)ann.getClassName());
        List annValues = ann.getParams();
        AnnotationsScannerTestCase.assertNotNull((Object)annValues);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)annValues.size());
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"ClassLevel"), annValues.get(0));
    }

    public void testMethodAnnotations() throws Exception {
        List methodAnnotations = this.scanner.getMethodAnnotations();
        System.out.println("Method annotations: " + methodAnnotations);
        AnnotationsScannerTestCase.assertNotNull((Object)methodAnnotations);
        AnnotationsScannerTestCase.assertEquals((int)2, (int)methodAnnotations.size());
        AnnotationInfo ann = (AnnotationInfo)methodAnnotations.get(0);
        AnnotationsScannerTestCase.assertEquals((String)Marker.class.getName(), (String)ann.getClassName());
        List annValues = ann.getParams();
        AnnotationsScannerTestCase.assertNotNull((Object)annValues);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)annValues.size());
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"MethodLevel / Main"), annValues.get(0));
        ann = (AnnotationInfo)methodAnnotations.get(1);
        AnnotationsScannerTestCase.assertEquals((String)Marker.class.getName(), (String)ann.getClassName());
        annValues = ann.getParams();
        AnnotationsScannerTestCase.assertNotNull((Object)annValues);
        AnnotationsScannerTestCase.assertEquals((int)1, (int)annValues.size());
        AnnotationsScannerTestCase.assertEquals((Object)new AnnotationInfo.NameValue("value", (Object)"MethodLevel / toString"), annValues.get(0));
    }
}

