/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.store.InMemoryObjectStore;

public class InMemoryStoreTestCase
extends AbstractMuleTestCase {
    public void testTimedExpiry() throws Exception {
        InMemoryObjectStore store = new InMemoryObjectStore();
        store.setName("timed");
        store.setMaxEntries(3);
        store.setEntryTTL(3000);
        store.setExpirationInterval(1000);
        store.initialise();
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("1", (Object)"1"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("2", (Object)"2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("3", (Object)"3"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("1"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("3"));
        Thread.sleep(4000L);
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("1"));
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("2"));
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("3"));
    }

    public void testMaxSize() throws Exception {
        InMemoryObjectStore store = new InMemoryObjectStore();
        store.setName("bounded");
        store.setMaxEntries(3);
        store.setEntryTTL(-1);
        store.setExpirationInterval(1000);
        store.initialise();
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("1", (Object)"1"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("2", (Object)"2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("3", (Object)"3"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("1"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("3"));
        Thread.sleep(3000L);
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("1"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("3"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("4", (Object)"4"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("1"));
        store.expire();
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("1"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("3"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("4"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("5", (Object)"5"));
        store.expire();
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("2"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("3"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("4"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("5"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("6", (Object)"6"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("7", (Object)"7"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("8", (Object)"8"));
        InMemoryStoreTestCase.assertTrue((boolean)store.storeObject("9", (Object)"9"));
        store.expire();
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("7"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("8"));
        InMemoryStoreTestCase.assertTrue((boolean)store.containsObject("9"));
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("3"));
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("4"));
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("5"));
        InMemoryStoreTestCase.assertFalse((boolean)store.containsObject("6"));
    }
}

