/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.retry.RetryContext;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.udp.UdpConnector;

public class UdpMessageRequester
extends AbstractMessageRequester {
    protected final UdpConnector connector;

    public UdpMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (UdpConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryContext validateConnection(RetryContext retryContext) {
        DatagramSocket socket = null;
        try {
            socket = this.connector.getSocket(this.endpoint);
            retryContext.setOk();
        }
        catch (Exception ex) {
            retryContext.setFailed(ex);
        }
        finally {
            block13: {
                if (socket != null) {
                    try {
                        this.connector.releaseSocket(socket, this.endpoint);
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.debug((Object)("Failed to release a socket " + socket), (Throwable)e);
                    }
                }
            }
        }
        return retryContext;
    }

    protected void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramPacket request(DatagramSocket socket, int timeout) throws IOException {
        int origTimeout = socket.getSoTimeout();
        try {
            DatagramPacket packet = new DatagramPacket(new byte[this.connector.getReceiveBufferSize()], this.connector.getReceiveBufferSize());
            if (timeout > 0 && timeout != socket.getSoTimeout()) {
                socket.setSoTimeout(timeout);
            }
            socket.receive(packet);
            DatagramPacket datagramPacket = packet;
            return datagramPacket;
        }
        finally {
            if (socket.getSoTimeout() != origTimeout) {
                socket.setSoTimeout(origTimeout);
            }
        }
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        DatagramSocket socket = this.connector.getSocket(this.endpoint);
        DatagramPacket result = this.request(socket, (int)timeout);
        if (result == null) {
            return null;
        }
        return new DefaultMuleMessage((Object)this.connector.getMessageAdapter(result), (Map)null);
    }

    protected void doDispose() {
    }
}

