/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;

public class Chat {
    private static String prefix = StringUtils.randomString(5);
    private static long id = 0L;
    private XMPPConnection connection;
    private String threadID;
    private String participant;
    private PacketFilter messageFilter;
    private PacketCollector messageCollector;
    private Set listeners = new HashSet();

    private static synchronized String nextID() {
        return prefix + Long.toString(id++);
    }

    public Chat(XMPPConnection connection, String participant) {
        this(connection, participant, Chat.nextID());
    }

    public Chat(XMPPConnection connection, String participant, String threadID) {
        this.connection = connection;
        this.participant = participant;
        this.threadID = threadID;
        connection.chats.put(StringUtils.parseBareAddress(participant), new WeakReference<Chat>(this));
        this.messageFilter = new ThreadFilter(threadID);
        this.messageCollector = connection.createPacketCollector(this.messageFilter);
    }

    public String getThreadID() {
        return this.threadID;
    }

    public String getParticipant() {
        return this.participant;
    }

    public void sendMessage(String text) throws XMPPException {
        Message message = this.createMessage();
        message.setBody(text);
        this.connection.sendPacket(message);
    }

    public Message createMessage() {
        Message message = new Message(this.participant, Message.Type.CHAT);
        message.setThread(this.threadID);
        return message;
    }

    public void sendMessage(Message message) throws XMPPException {
        message.setTo(this.participant);
        message.setType(Message.Type.CHAT);
        message.setThread(this.threadID);
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.messageFilter);
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(new WeakReference<PacketListener>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliver(Message message) {
        message.setThread(this.threadID);
        this.messageCollector.processPacket(message);
        Set set = this.listeners;
        synchronized (set) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                WeakReference listenerRef = (WeakReference)i.next();
                PacketListener listener = (PacketListener)listenerRef.get();
                if (listener != null) {
                    listener.processPacket(message);
                    continue;
                }
                i.remove();
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            if (this.messageCollector != null) {
                this.messageCollector.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

