/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.io;

import cryptix.openpgp.io.PGPDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class PGPLengthDataOutputStream
extends PGPDataOutputStream {
    private OutputStream out;
    private ByteArrayOutputStream buffer = null;
    private boolean lengthHasBeenWritten = false;
    private boolean partial = false;
    private long chunkBytesWritten = 0L;
    private long chunkLength = 0L;

    public PGPLengthDataOutputStream() {
        this.out = null;
    }

    public PGPLengthDataOutputStream(OutputStream out) {
        this.out = out;
    }

    public void close() throws IOException {
        if (this.partial) {
            throw new IllegalStateException("Packet cannot end with a partial length");
        }
        if (this.lengthHasBeenWritten && this.chunkBytesWritten != this.chunkLength) {
            throw new IllegalStateException("Packet has not been completely written");
        }
        if (!this.lengthHasBeenWritten) {
            byte[] b = this.buffer != null ? this.buffer.toByteArray() : new byte[]{};
            this.chunkLength = b.length;
            this.chunkBytesWritten = 0L;
            this.lengthHasBeenWritten = true;
            this.writeLength(this.out, b.length);
            this.writeFully(b);
        }
    }

    public void setLength(long len) throws IOException {
        if (this.partial && this.chunkBytesWritten != this.chunkLength) {
            throw new IllegalStateException("Partial length has not yet been completed");
        }
        if (this.partial) {
            this.partial = false;
        } else {
            if (this.lengthHasBeenWritten) {
                throw new IllegalStateException("Cannot write two non-partial lengths");
            }
            if (!this.lengthHasBeenWritten && this.chunkBytesWritten != 0L) {
                throw new IllegalStateException("Bytes have already been written");
            }
        }
        this.chunkLength = len;
        this.chunkBytesWritten = 0L;
        this.lengthHasBeenWritten = true;
        this.writeLength(this.out, len);
    }

    public void setPartialLength(long len) throws IOException {
        if (this.partial && this.chunkBytesWritten != this.chunkLength) {
            throw new IllegalStateException("Partial length has not yet been completed");
        }
        if (this.lengthHasBeenWritten) {
            throw new IllegalStateException("Cannot set a partial length after a normal length");
        }
        if (!this.lengthHasBeenWritten && this.chunkBytesWritten != 0L) {
            throw new IllegalStateException("Bytes have already been written");
        }
        this.partial = true;
        this.chunkLength = len;
        this.chunkBytesWritten = 0L;
        this.lengthHasBeenWritten = true;
        this.writePartialLength(this.out, len);
    }

    protected void writeDirect(int b) throws IOException {
        this.out.write(b);
    }

    protected void writeInternal(int b) throws IOException {
        if (!this.lengthHasBeenWritten) {
            if (this.chunkBytesWritten == 0L) {
                this.buffer = new ByteArrayOutputStream();
            }
            this.buffer.write(b);
            ++this.chunkBytesWritten;
        } else {
            ++this.chunkBytesWritten;
            if (this.chunkBytesWritten > this.chunkLength) {
                throw new RuntimeException("Tried to write more bytes than set.");
            }
            this.writeDirect(b);
        }
    }

    protected abstract void writeLength(OutputStream var1, long var2) throws IOException;

    protected abstract void writePartialLength(OutputStream var1, long var2) throws IOException;
}

