/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public abstract class PGPDummyPacket
extends PGPPacket {
    private byte[] payload;

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.setPayload(in.readByteArray());
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        if (this.getPayload() == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        out.setLength(this.getPayload().length);
        out.writeFully(this.getPayload());
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPDummyPacket)) {
            return false;
        }
        PGPDummyPacket that = (PGPDummyPacket)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getPayload(), that.getPayload());
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        if (payload == null || payload.length == 0) {
            throw new IllegalArgumentException("Array size == 0");
        }
        this.payload = payload;
    }
}

