/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPAbstractDataFormatException;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPWrongPassphraseException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPPublicKeyAlgorithm;
import cryptix.openpgp.algorithm.PGPStringToKey;
import cryptix.openpgp.io.PGPByteArrayDataInputStream;
import cryptix.openpgp.io.PGPByteArrayDataOutputStream;
import cryptix.openpgp.io.PGPChecksumDataInputStream;
import cryptix.openpgp.io.PGPChecksumDataOutputStream;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPCryptHelper;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPPublicSubKeyPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.KeySpec;
import java.util.Date;
import javax.crypto.Cipher;

public abstract class PGPKeyPacket
extends PGPPacket
implements KeySpec {
    private PGPPublicKeyAlgorithm algorithm;
    private int version;
    private Date creation;
    private int expire;
    private byte algoid;
    private byte[] secretdata;

    protected PGPKeyPacket() {
    }

    protected PGPKeyPacket(PGPKeyPacket toClone) {
        this.algorithm = toClone.algorithm.clonePrivate();
        this.version = toClone.version;
        this.creation = toClone.creation;
        this.expire = toClone.expire;
        this.algoid = toClone.algoid;
        this.secretdata = toClone.secretdata;
        this.setPacketID(toClone.getPacketID());
    }

    public abstract Object clone();

    public PGPPublicKeyPacket clonePublic() {
        PGPPublicKeyPacket newpkt = new PGPPublicKeyPacket();
        newpkt.setAlgorithm(this.algorithm.clonePublic(), this.algoid);
        newpkt.setCreationDate(this.creation);
        newpkt.setV23ExpirationDate(this.expire);
        newpkt.setVersion(this.version);
        return newpkt;
    }

    public PGPPublicSubKeyPacket clonePublicSub() {
        PGPPublicSubKeyPacket newpkt = new PGPPublicSubKeyPacket();
        newpkt.setAlgorithm(this.algorithm.clonePublic(), this.algoid);
        newpkt.setCreationDate(this.creation);
        newpkt.setVersion(this.version);
        return newpkt;
    }

    private boolean compare(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    protected void decodePublicData(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.version = in.readUnsignedByte();
        if (this.version < 2 || this.version > 4) {
            throw new RuntimeException("Unknown Keypacket version #" + this.version);
        }
        long d = in.readUnsignedInt();
        this.creation = new Date(d * 1000L);
        this.expire = this.version == 4 ? -1 : in.readUnsignedShort();
        this.algoid = (byte)in.readUnsignedByte();
        try {
            this.algorithm = factory.getPublicKeyAlgorithm(this.algoid);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new PGPDataFormatException("id not found - " + nsae);
        }
        this.algorithm.decodePublicData(in);
    }

    protected void decodeSecretData(PGPPacketDataInputStream in) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        this.secretdata = in.readByteArray();
        if (this.secretdata[0] == 0) {
            PGPByteArrayDataInputStream pbais = new PGPByteArrayDataInputStream(this.secretdata);
            pbais.readByte();
            PGPChecksumDataInputStream cdis = new PGPChecksumDataInputStream(pbais);
            this.algorithm.decodeSecretData(cdis);
            cdis.close();
            pbais.close();
        }
    }

    public void decrypt(char[] passphrase, PGPAlgorithmFactory factory) throws PGPWrongPassphraseException, PGPDataFormatException {
        try {
            byte[] result;
            int blocksize;
            int keysize;
            Cipher cp;
            MessageDigest md;
            PGPStringToKey s2k;
            int hashid;
            int s2kid;
            ByteArrayInputStream bais = new ByteArrayInputStream(this.secretdata);
            DataInputStream in = new DataInputStream(bais);
            int alg = in.readUnsignedByte();
            boolean hashcheck = false;
            if (alg == 255) {
                alg = in.readUnsignedByte();
                s2kid = in.readUnsignedByte();
                hashid = in.readUnsignedByte();
            } else if (alg == 254) {
                alg = in.readUnsignedByte();
                s2kid = in.readUnsignedByte();
                hashid = in.readUnsignedByte();
                hashcheck = true;
            } else if (alg != 0) {
                s2kid = 0;
                hashid = 1;
            } else {
                return;
            }
            try {
                s2k = factory.getS2KAlgorithm(s2kid);
                md = factory.getHashAlgorithm(hashid);
                cp = factory.getCipherAlgorithm(alg, "CFB");
                keysize = factory.getCipherKeySize(alg);
                blocksize = factory.getCipherBlockSize(alg);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalArgumentException("id not found - " + nsae);
            }
            byte[] passbytes = new String(passphrase).getBytes("UTF-8");
            byte[] key = s2k.readAndHash(passbytes, md, keysize, in);
            byte[] iv = new byte[blocksize];
            in.readFully(iv);
            byte[] data = new byte[in.available()];
            in.readFully(data);
            if (this.version == 4) {
                result = PGPCryptHelper.crypt(false, cp, iv, key, data);
                if (!hashcheck) {
                    int sum = 0;
                    int i = 0;
                    while (i < result.length - 2) {
                        sum += result[i] & 0xFF;
                        ++i;
                    }
                    int expected = ((result[result.length - 2] & 0xFF) << 8) + (result[result.length - 1] & 0xFF);
                    if ((sum &= 0xFFFF) != expected) {
                        throw new PGPWrongPassphraseException("Wrong passphrase");
                    }
                } else {
                    try {
                        md = MessageDigest.getInstance("SHA-1");
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        throw new InternalError("SHA-1 hash not found - " + nsae);
                    }
                    md.update(result, 0, result.length - 20);
                    byte[] digest = md.digest();
                    int i = 0;
                    while (i < 20) {
                        if (digest[i] != result[result.length - 20 + i]) {
                            throw new PGPWrongPassphraseException("Wrong passphrase");
                        }
                        ++i;
                    }
                }
            } else if (this.version == 2 || this.version == 3) {
                int pos = 0;
                int mpilen = ((data[pos++] & 0xFF) << 8) + (data[pos++] & 0xFF) + 7 >> 3;
                int i = 0;
                while (i < 4) {
                    try {
                        cp = factory.getCipherAlgorithm(alg, "CFB");
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        throw new IllegalArgumentException("id not found - " + nsae);
                    }
                    byte[] mpidata = new byte[mpilen];
                    System.arraycopy(data, pos, mpidata, 0, mpilen);
                    byte[] mpiresult = PGPCryptHelper.crypt(false, cp, iv, key, mpidata);
                    System.arraycopy(data, pos + mpilen - blocksize, iv, 0, blocksize);
                    System.arraycopy(mpiresult, 0, data, pos, mpilen);
                    pos += mpilen;
                    mpilen = ((data[pos++] & 0xFF) << 8) + (data[pos++] & 0xFF) + 7 >> 3;
                    ++i;
                }
                result = new byte[data.length];
                System.arraycopy(data, 0, result, 0, data.length);
                int sum = 0;
                int i2 = 0;
                while (i2 < result.length - 2) {
                    sum += result[i2] & 0xFF;
                    ++i2;
                }
                int expected = ((result[result.length - 2] & 0xFF) << 8) + (result[result.length - 1] & 0xFF);
                if ((sum &= 0xFFFF) != expected) {
                    throw new PGPWrongPassphraseException("Wrong passphrase");
                }
            } else {
                throw new PGPDataFormatException("Invalid version");
            }
            try {
                PGPByteArrayDataInputStream pbais = new PGPByteArrayDataInputStream(result);
                this.algorithm.decodeSecretData(pbais);
                if (!hashcheck) {
                    pbais.readShort();
                } else {
                    pbais.readInt();
                    pbais.readLong();
                    pbais.readLong();
                }
                pbais.close();
            }
            catch (PGPAbstractDataFormatException pGPAbstractDataFormatException) {
                throw new PGPWrongPassphraseException("Wrong passphrase");
            }
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on bytearray");
        }
    }

    protected void encodePublicData(PGPPacketDataOutputStream out) throws IOException {
        if (this.version < 2 || this.version > 4) {
            throw new IllegalStateException("Invalid version " + this.version);
        }
        out.writeByte((byte)this.version);
        if (this.creation == null) {
            System.out.println("Warning! Creation date not set!");
            this.creation = new Date();
        }
        int time = (int)(this.creation.getTime() / 1000L);
        out.writeInt(time);
        if (this.version == 2 || this.version == 3) {
            out.writeShort((short)this.expire);
        }
        out.writeByte(this.algoid);
        this.algorithm.encodePublicData(out);
    }

    protected void encodeSecretData(PGPPacketDataOutputStream out) throws IOException {
        if (this.version < 2 || this.version > 4) {
            throw new IllegalStateException("Invalid version " + this.version);
        }
        if (this.secretdata != null) {
            out.writeFully(this.secretdata);
        } else {
            out.writeByte((byte)0);
            PGPChecksumDataOutputStream cdos = new PGPChecksumDataOutputStream(out);
            this.algorithm.encodeSecretData(cdos);
            cdos.close();
        }
    }

    public void encrypt(char[] passphrase, int s2kid, int cipherid, int hashid, SecureRandom sr, PGPAlgorithmFactory factory) {
        if (this.version < 2 || this.version > 4) {
            throw new IllegalStateException("Invalid version " + this.version);
        }
        try {
            int blocksize;
            int keysize;
            Cipher cp;
            MessageDigest md;
            PGPStringToKey s2k;
            PGPByteArrayDataOutputStream pbados = new PGPByteArrayDataOutputStream();
            this.algorithm.encodeSecretData(pbados);
            byte[] temp = pbados.toByteArray();
            int sum = 0;
            int i = 0;
            while (i < temp.length) {
                sum += temp[i] & 0xFF;
                ++i;
            }
            byte[] data = new byte[temp.length + 2];
            System.arraycopy(temp, 0, data, 0, temp.length);
            data[temp.length] = (byte)(sum >> 8 & 0xFF);
            data[temp.length + 1] = (byte)(sum & 0xFF);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            if (this.version == 4) {
                out.writeByte(-1);
                out.writeByte((byte)cipherid);
                out.writeByte((byte)s2kid);
                out.writeByte((byte)hashid);
            } else {
                out.writeByte((byte)cipherid);
                if (s2kid != 0) {
                    throw new IllegalArgumentException("s2kid should be 0 = simple for legacy keys");
                }
                if (hashid != 1) {
                    throw new IllegalArgumentException("hashid should be 1 = MD5 for legacy keys");
                }
            }
            try {
                s2k = factory.getS2KAlgorithm(s2kid);
                md = factory.getHashAlgorithm(hashid);
                cp = factory.getCipherAlgorithm(cipherid, "CFB");
                keysize = factory.getCipherKeySize(cipherid);
                blocksize = factory.getCipherBlockSize(cipherid);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new IllegalArgumentException("id not found - " + nsae);
            }
            byte[] passbytes = new String(passphrase).getBytes("UTF-8");
            byte[] key = s2k.generateAndHash(passbytes, md, keysize, out, sr);
            byte[] iv = new byte[blocksize];
            sr.nextBytes(iv);
            out.write(iv);
            if (this.version == 4) {
                out.write(PGPCryptHelper.crypt(true, cp, iv, key, data));
            } else {
                int pos = 0;
                int i2 = 0;
                while (i2 < 4) {
                    out.write(data, pos, 2);
                    int mpilen = ((data[pos++] & 0xFF) << 8) + (data[pos++] & 0xFF) + 7 >> 3;
                    byte[] mpidata = new byte[mpilen];
                    System.arraycopy(data, pos, mpidata, 0, mpilen);
                    byte[] mpiresult = PGPCryptHelper.crypt(true, cp, iv, key, mpidata);
                    out.write(mpiresult);
                    System.arraycopy(mpiresult, mpilen - blocksize, iv, 0, blocksize);
                    pos += mpilen;
                    ++i2;
                }
                out.write(data, pos, 2);
                if (pos + 2 != data.length) {
                    throw new InternalError("Extra secret data");
                }
            }
            out.close();
            baos.close();
            this.secretdata = baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException on bytearray");
        }
    }

    public boolean equals(Object ssp) {
        if (ssp instanceof PGPKeyPacket) {
            PGPKeyPacket kp = (PGPKeyPacket)ssp;
            return this.compare(this.creation, kp.getCreationDate()) && this.expire == kp.getV23ExpirationDate() && this.version == kp.getVersion() && this.compare(this.algorithm, kp.getAlgorithm());
        }
        return false;
    }

    public void forgetSecretData() {
        this.algorithm.forgetSecretData();
    }

    public PGPPublicKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte getAlgorithmID() {
        return this.algoid;
    }

    public Date getCreationDate() {
        return this.creation;
    }

    public int getForceLengthType() {
        if (this.version <= 3) {
            return 1;
        }
        return -1;
    }

    public int getV23ExpirationDate() {
        return this.expire;
    }

    public int getVersion() {
        return this.version;
    }

    public void setAlgorithm(PGPPublicKeyAlgorithm algorithm, byte algoid) {
        this.algorithm = algorithm;
        this.algoid = algoid;
    }

    public void setAlgorithmID(byte a) {
        this.algoid = a;
    }

    public void setCreationDate(Date date) {
        this.creation = date;
    }

    public void setV23ExpirationDate(int e) {
        this.expire = e;
    }

    public void setVersion(int v) {
        this.version = v;
    }
}

