/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.mule.api.DefaultMuleException;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;

class ReceiverFileInputStream
extends FileInputStream {
    private File currentFile;
    private boolean deleteOnClose;
    private File moveToOnClose;

    public ReceiverFileInputStream(File currentFile, boolean deleteOnClose, File moveToOnClose) throws FileNotFoundException {
        super(currentFile);
        this.currentFile = currentFile;
        this.deleteOnClose = deleteOnClose;
        this.moveToOnClose = moveToOnClose;
    }

    public void close() throws IOException {
        super.close();
        if (this.moveToOnClose != null) {
            FileUtils.moveFile(this.currentFile, this.moveToOnClose);
        } else if (this.deleteOnClose && !this.currentFile.delete()) {
            try {
                throw new DefaultMuleException(FileMessages.failedToDeleteFile(this.currentFile));
            }
            catch (DefaultMuleException e) {
                IOException e2 = new IOException();
                e2.initCause(e);
                throw e2;
            }
        }
    }

    public File getCurrentFile() {
        return this.currentFile;
    }
}

