/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.http.HttpResponse;

public class HttpMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -1544495479333000422L;
    private boolean http11 = true;
    private Object message;

    public HttpMessageAdapter(Object message) {
        NameValuePair param;
        HeaderElement[] values;
        Header contenttype;
        if (message instanceof Object[]) {
            Object[] messageParts = (Object[])message;
            this.message = messageParts[0];
            HashMap headers = new HashMap();
            if (messageParts.length > 1) {
                Object second = messageParts[1];
                if (second instanceof Map) {
                    Map props = (Map)second;
                    for (Map.Entry e : props.entrySet()) {
                        String key = (String)e.getKey();
                        Object value = e.getValue();
                        if (value == null) continue;
                        headers.put(key, value);
                    }
                } else if (second instanceof Header[]) {
                    Header[] inboundHeaders = (Header[])second;
                    for (int i = 0; i < inboundHeaders.length; ++i) {
                        headers.put(inboundHeaders[i].getName(), inboundHeaders[i].getValue());
                    }
                }
                this.addInboundProperties(headers);
            }
        } else {
            if (message instanceof HttpResponse) {
                this.message = message;
                return;
            }
            this.message = message;
        }
        String temp = this.getStringProperty("http.version", null);
        if ("HTTP/1.0".equalsIgnoreCase(temp)) {
            this.http11 = false;
        }
        if ((contenttype = this.getHeader("Content-Type")) != null && (values = contenttype.getElements()).length == 1 && (param = values[0].getParameterByName("charset")) != null) {
            this.setEncoding(param.getValue());
        }
    }

    protected HttpMessageAdapter(HttpMessageAdapter template) {
        super((MessageAdapter)template);
        this.message = template.message;
        this.http11 = template.http11;
    }

    public Object getPayload() {
        return this.message;
    }

    public Object getProperty(String key) {
        if ("Keep-Alive".equals(key) || "Connection".equals(key)) {
            if (!this.http11) {
                String connection = super.getStringProperty("Connection", null);
                if (connection != null && connection.equalsIgnoreCase("close")) {
                    return "false";
                }
                return "true";
            }
            return super.getProperty("Connection") != null ? "true" : "false";
        }
        return super.getProperty(key);
    }

    public Header getHeader(String name) {
        String value = this.getStringProperty(name, null);
        if (value == null) {
            return null;
        }
        return new Header(name, value);
    }

    public ThreadSafeAccess newThreadCopy() {
        return new HttpMessageAdapter(this);
    }
}

