/*
 * $Id: HttpRequestToParameterMap.java 13563 2008-12-05 18:27:05Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.servlet.transformers;

import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;
import org.mule.transport.servlet.HttpRequestMessageAdapter;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * Returns a simple Map of the parameters sent with the HTTP Request.  
 * If the same parameter is given more than once, only the first value for it will be in the Map.
 */
public class HttpRequestToParameterMap extends AbstractMessageAwareTransformer
{
    public HttpRequestToParameterMap()
    {
        registerSourceType(Object.class);
        setReturnClass(Map.class);
    }

    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException
    {
        HttpServletRequest request = ((HttpRequestMessageAdapter) message.getAdapter()).getRequest();
        Enumeration <String> paramNames = request.getParameterNames();
        
        Map <String, String> parameters = new HashMap();
        String paramName;
        while (paramNames.hasMoreElements())
        {
            paramName = (String) paramNames.nextElement();            
            parameters.put(paramName, request.getParameterValues(paramName)[0]);
        }
        return parameters;
    }
}
