/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.IOException;
import java.io.OutputStream;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.util.ClassUtils;

public class ProtocolStream
extends OutputStream {
    private boolean streamOk;
    private TcpProtocol protocol;
    private OutputStream os;

    public ProtocolStream(TcpProtocol protocol, boolean streamOk, OutputStream os) {
        this.protocol = protocol;
        this.streamOk = streamOk;
        this.os = os;
    }

    private void assertStreamOk() {
        if (!this.streamOk) {
            throw new IllegalArgumentException("TCP protocol " + ClassUtils.getSimpleName(this.protocol.getClass()) + " does not support streaming output");
        }
    }

    public void write(byte[] b) throws IOException {
        this.assertStreamOk();
        this.protocol.write(this.os, b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.assertStreamOk();
        byte[] buffer = new byte[len];
        System.arraycopy(b, off, buffer, 0, len);
        this.protocol.write(this.os, buffer);
    }

    public void flush() throws IOException {
        this.assertStreamOk();
        this.os.flush();
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void close() throws IOException {
        this.assertStreamOk();
        this.os.close();
    }
}

