/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Bayeux;
import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.Message;
import dojox.cometd.MessageListener;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mortbay.cometd.ChannelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BayeuxService {
    private String _name;
    private Bayeux _bayeux;
    private Client _client;
    private Map<String, Method> _methods = new ConcurrentHashMap<String, Method>();

    public BayeuxService(Bayeux bayeux, String name) {
        this._name = name;
        this._bayeux = bayeux;
        this._client = this._bayeux.newClient(name);
        this._client.addListener((EventListener)((Object)new Listen()));
    }

    public Bayeux getBayeux() {
        return this._bayeux;
    }

    public Client getClient() {
        return this._client;
    }

    protected void subscribe(String channelId, String methodName) {
        Method method = null;
        for (Class<?> c = this.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            Method[] methods = c.getDeclaredMethods();
            int i = methods.length;
            while (i-- > 0) {
                if (!methodName.equals(methods[i].getName())) continue;
                if (method != null) {
                    throw new IllegalArgumentException("Multiple methods called '" + methodName + "'");
                }
                method = methods[i];
            }
        }
        if (method == null) {
            throw new NoSuchMethodError(methodName);
        }
        int params = method.getParameterTypes().length;
        if (params < 2 || params > 4) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have 2or3 parameters");
        }
        if (!Client.class.isAssignableFrom(method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Method '" + methodName + "' does not have Client as first parameter");
        }
        Channel channel = this._bayeux.getChannel(channelId, true);
        if (((ChannelImpl)channel).getChannelId().isWild()) {
            final Method m = method;
            Client wild_client = this._bayeux.newClient(this._name + "-wild");
            wild_client.addListener((EventListener)new MessageListener(){

                public void deliver(Client fromClient, Client toClient, Message msg) {
                    BayeuxService.this.invoke(m, fromClient, toClient, (Map)msg);
                }
            });
            channel.subscribe(wild_client);
        } else {
            this._methods.put(channelId, method);
            channel.subscribe(this._client);
        }
    }

    protected void send(Client toClient, String onChannel, Object data, String id) {
        toClient.deliver(this.getClient(), onChannel, data, id);
    }

    protected void exception(Client fromClient, Client toClient, Map<String, Object> msg, Throwable th) {
        th.printStackTrace();
    }

    private void deliver(Client fromClient, Client toClient, Map<String, Object> msg) {
        String channel = (String)msg.get("channel");
        Method method = this._methods.get(channel);
        this.invoke(method, fromClient, toClient, msg);
    }

    private void invoke(Method method, Client fromClient, Client toClient, Map<String, Object> msg) {
        String channel = (String)msg.get("channel");
        Object data = msg.get("data");
        String id = (String)msg.get("id");
        if (method != null) {
            try {
                Class<?>[] args = method.getParameterTypes();
                Object arg = Message.class.isAssignableFrom(args[1]) ? msg : data;
                Object reply = null;
                switch (method.getParameterTypes().length) {
                    case 2: {
                        reply = method.invoke((Object)this, fromClient, arg);
                        break;
                    }
                    case 3: {
                        reply = method.invoke((Object)this, fromClient, arg, id);
                        break;
                    }
                    case 4: {
                        reply = method.invoke((Object)this, fromClient, channel, arg, id);
                    }
                }
                if (reply != null) {
                    this.send(fromClient, channel, reply, id);
                }
            }
            catch (Exception e) {
                this.exception(fromClient, toClient, msg, e);
            }
            catch (Error e) {
                this.exception(fromClient, toClient, msg, e);
            }
        }
    }

    private class Listen
    implements MessageListener {
        private Listen() {
        }

        public void deliver(Client fromClient, Client toClient, Message msg) {
            BayeuxService.this.deliver(fromClient, toClient, (Map)msg);
        }
    }
}

