/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.MessageFactorySpi;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.packet.PGPCompressedDataPacket;
import cryptix.openpgp.packet.PGPEncryptedDataPacket;
import cryptix.openpgp.packet.PGPLiteralDataPacket;
import cryptix.openpgp.packet.PGPOnePassSignaturePacket;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.packet.PGPPacketFactory;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPSecretKeyPacket;
import cryptix.openpgp.packet.PGPSessionKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.provider.PGPDetachedSignatureMessageImpl;
import cryptix.openpgp.provider.PGPEncryptedMessageImpl;
import cryptix.openpgp.provider.PGPKeyBundleFactory;
import cryptix.openpgp.provider.PGPKeyBundleImpl;
import cryptix.openpgp.provider.PGPKeyBundleMessageImpl;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.provider.PGPSignedMessageImpl;
import cryptix.openpgp.util.PGPArmoury;
import cryptix.pki.KeyBundleException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class PGPMessageFactory
extends MessageFactorySpi {
    public static final String CRLF = "\r\n";

    public Message engineGenerateMessage(InputStream in) throws MessageException {
        throw new RuntimeException("NYI");
    }

    public Collection engineGenerateMessages(InputStream stream) throws MessageException, IOException {
        BufferedInputStream in = new BufferedInputStream(stream);
        in.mark(1);
        int firstbyte = in.read();
        in.reset();
        if (firstbyte > 127) {
            return this.generateBinary(in);
        }
        return this.generateAscii(in);
    }

    private Collection generateAscii(BufferedInputStream in) throws MessageException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        StringBuffer buf = new StringBuffer();
        Vector<Object> result = new Vector<Object>();
        String line = br.readLine();
        while (line != null) {
            if (line.startsWith("-----BEGIN")) {
                PGPArmoury armoury;
                do {
                    buf.append(line);
                    buf.append(CRLF);
                } while ((line = br.readLine()) != null && !line.startsWith("-----END"));
                if (line != null) {
                    buf.append(line);
                    buf.append(CRLF);
                    line = br.readLine();
                }
                try {
                    armoury = new PGPArmoury(buf.toString());
                }
                catch (IllegalArgumentException iae) {
                    throw new MessageException(iae.getMessage());
                }
                if (armoury.getClearText() != null) {
                    String text;
                    try {
                        text = new String(armoury.getClearText(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException uee) {
                        throw new InternalError("UTF-8 encoding not supported - " + uee);
                    }
                    byte[] data = armoury.getPayload();
                    PGPLiteralDataPacket ldp = new PGPLiteralDataPacket();
                    ldp.setData(text);
                    PGPLiteralMessageImpl lm = new PGPLiteralMessageImpl(ldp);
                    PGPPacketFactory pf = PGPPacketFactory.getDefaultInstance();
                    PGPAlgorithmFactory af = PGPAlgorithmFactory.getDefaultInstance();
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    PGPPacket pkt = null;
                    try {
                        pkt = pf.readPacket(bais, af);
                    }
                    catch (PGPDataFormatException dfe) {
                        throw new MessageException(String.valueOf(String.valueOf(dfe)));
                    }
                    catch (PGPFatalDataFormatException fdfe) {
                        throw new MessageException(String.valueOf(String.valueOf(fdfe)));
                    }
                    if (!(pkt instanceof PGPSignaturePacket)) {
                        throw new MessageException("Signature expected");
                    }
                    PGPSignaturePacket sp = (PGPSignaturePacket)pkt;
                    PGPSignedMessageImpl sm = new PGPSignedMessageImpl(false, sp, lm);
                    result.add((Object)sm);
                } else {
                    byte[] data = armoury.getPayload();
                    ByteArrayInputStream bais = new ByteArrayInputStream(data);
                    result.addAll(this.generateBinary(bais));
                }
            } else {
                do {
                    buf.append(line);
                    buf.append(CRLF);
                } while ((line = br.readLine()) != null && !line.startsWith("-----BEGIN"));
                PGPLiteralDataPacket ldp = new PGPLiteralDataPacket();
                ldp.setData(buf.toString());
                PGPLiteralMessageImpl lm = new PGPLiteralMessageImpl(ldp);
                result.add((Object)lm);
            }
            buf = new StringBuffer();
        }
        return result;
    }

    private Collection generateBinary(InputStream in) throws MessageException, IOException {
        PGPPacketFactory pf = PGPPacketFactory.getDefaultInstance();
        PGPAlgorithmFactory af = PGPAlgorithmFactory.getDefaultInstance();
        PGPPacket pkt = null;
        Vector<Object> result = new Vector<Object>();
        Vector<PGPPacket> sessionkeys = new Vector<PGPPacket>();
        while (in.available() > 0) {
            PGPLiteralMessageImpl lm;
            try {
                in.mark(16384);
                pkt = pf.readPacket(in, af);
            }
            catch (PGPDataFormatException dfe) {
                throw new MessageException(String.valueOf(String.valueOf(dfe)));
            }
            catch (PGPFatalDataFormatException fdfe) {
                throw new MessageException(String.valueOf(String.valueOf(fdfe)));
            }
            if (pkt instanceof PGPSessionKeyPacket) {
                sessionkeys.add(pkt);
                continue;
            }
            if (pkt instanceof PGPEncryptedDataPacket) {
                PGPSessionKeyPacket[] sks = new PGPSessionKeyPacket[sessionkeys.size()];
                int i = 0;
                while (i < sks.length) {
                    sks[i] = (PGPSessionKeyPacket)sessionkeys.elementAt(i);
                    ++i;
                }
                result.add((Object)new PGPEncryptedMessageImpl(sks, (PGPEncryptedDataPacket)pkt));
                continue;
            }
            if (pkt instanceof PGPPublicKeyPacket || pkt instanceof PGPSecretKeyPacket) {
                try {
                    in.reset();
                    Object x = PGPKeyBundleFactory.helper(in, false);
                    if (x instanceof Collection) {
                        Iterator it = ((Collection)x).iterator();
                        while (it.hasNext()) {
                            PGPKeyBundleImpl k = (PGPKeyBundleImpl)((Object)it.next());
                            result.add((Object)new PGPKeyBundleMessageImpl(k));
                        }
                        continue;
                    }
                    PGPKeyBundleImpl k = (PGPKeyBundleImpl)((Object)x);
                    result.add((Object)new PGPKeyBundleMessageImpl(k));
                    continue;
                }
                catch (KeyBundleException kbe) {
                    throw new MessageException(String.valueOf(String.valueOf((Object)kbe)));
                }
            }
            if (pkt instanceof PGPOnePassSignaturePacket) continue;
            if (pkt instanceof PGPCompressedDataPacket) {
                Enumeration en = ((PGPCompressedDataPacket)pkt).listPackets();
                Object obj = en.nextElement();
                if (obj instanceof PGPSignaturePacket) {
                    Object obj2 = en.nextElement();
                    if (!(obj2 instanceof PGPLiteralDataPacket)) {
                        throw new MessageException("Invalid message format.");
                    }
                    PGPSignedMessageImpl sm = new PGPSignedMessageImpl(false, (PGPSignaturePacket)obj, new PGPLiteralMessageImpl((PGPLiteralDataPacket)obj2));
                    result.add((Object)sm);
                    continue;
                }
                if (!(obj instanceof PGPLiteralDataPacket)) {
                    throw new MessageException("Invalid message format.");
                }
                PGPLiteralMessageImpl lm2 = new PGPLiteralMessageImpl((PGPLiteralDataPacket)obj);
                result.add((Object)lm2);
                continue;
            }
            if (pkt instanceof PGPLiteralDataPacket) {
                lm = new PGPLiteralMessageImpl((PGPLiteralDataPacket)pkt);
                if (result.size() > 0 && result.elementAt(result.size() - 1) instanceof PGPDetachedSignatureMessageImpl) {
                    PGPDetachedSignatureMessageImpl dsm = (PGPDetachedSignatureMessageImpl)((Object)result.remove(result.size() - 1));
                    PGPSignedMessageImpl sm = new PGPSignedMessageImpl(false, dsm.getPacket(), lm);
                    result.add((Object)sm);
                    continue;
                }
                result.add((Object)lm);
                continue;
            }
            if (!(pkt instanceof PGPSignaturePacket)) continue;
            if (result.size() > 0 && result.elementAt(result.size() - 1) instanceof PGPLiteralMessageImpl) {
                lm = (PGPLiteralMessageImpl)((Object)result.remove(result.size() - 1));
                PGPSignedMessageImpl sm = new PGPSignedMessageImpl(false, (PGPSignaturePacket)pkt, lm);
                result.add((Object)sm);
                continue;
            }
            PGPDetachedSignatureMessageImpl dsm = new PGPDetachedSignatureMessageImpl((PGPSignaturePacket)pkt);
            result.add((Object)dsm);
        }
        return result;
    }
}

