/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;
import java.util.Date;

public class PGPDateSP
extends PGPSignatureSubPacket {
    private Date value;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        long m = in.readUnsignedInt();
        this.setValue(new Date(m *= 1000L));
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue() == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        long m = this.getValue().getTime();
        int d = (int)(m /= 1000L);
        out.writeInt(d);
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPDateSP)) {
            return false;
        }
        PGPDateSP that = (PGPDateSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue());
    }

    public Date getValue() {
        return this.value;
    }

    public void setValue(Date value) {
        long m = value.getTime();
        if (m < 0L || m > 4294967295000L) {
            throw new IllegalArgumentException("Date not within acceptable range");
        }
        this.value = value;
    }
}

