/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPFeaturesSP
extends PGPSignatureSubPacket {
    public static final byte FEATURE_MODIFICATION_DETECTION = 1;
    private byte[] data = new byte[0];

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        this.data = in.readByteArray();
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        out.writeFully(this.data);
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPFeaturesSP)) {
            return false;
        }
        PGPFeaturesSP that = (PGPFeaturesSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.data, that.data);
    }

    public void setSupportsFeature(byte feature, boolean support) {
        if (feature == 0) {
            throw new IllegalArgumentException("feature == 0");
        }
        if (this.supportsFeature(feature) != support) {
            if (support) {
                byte[] temp = new byte[this.data.length + 1];
                System.arraycopy(this.data, 0, temp, 0, this.data.length);
                temp[this.data.length] = feature;
                this.data = temp;
            } else {
                int i = 0;
                while (i < this.data.length) {
                    if (this.data[i] == feature) {
                        byte[] temp = new byte[this.data.length - 1];
                        System.arraycopy(this.data, 0, temp, 0, i);
                        System.arraycopy(this.data, i + 1, temp, i, temp.length - i);
                        this.data = temp;
                        i = this.data.length + 1;
                    }
                    ++i;
                }
            }
        }
    }

    public void setSupportsModificationDetection(boolean support) {
        this.setSupportsFeature((byte)1, support);
    }

    public boolean supportsFeature(byte feature) {
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] == feature) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean supportsModificationDetection() {
        return this.supportsFeature((byte)1);
    }
}

