/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.signature.PGPUnknownSP;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class PGPSignatureSubPacketFactory {
    public static final int INIT_DEFAULT = 0;
    public static final int INIT_EMPTY_ALL = 255;
    public static final int INIT_EMPTY = 255;
    private Hashtable PacketClasses = new Hashtable();
    private static final int[] defaultPacketIDs = new int[]{2, 3, 4, 5, 6, 7, 9, 11, 12, 16, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
    private static final String[] defaultPacketClasses = new String[]{"cryptix.openpgp.signature.PGPDateSP", "cryptix.openpgp.signature.PGPDateSP", "cryptix.openpgp.signature.PGPBooleanSP", "cryptix.openpgp.signature.PGPTrustSP", "cryptix.openpgp.signature.PGPNullTerminatedStringSP", "cryptix.openpgp.signature.PGPBooleanSP", "cryptix.openpgp.signature.PGPDateSP", "cryptix.openpgp.signature.PGPByteArraySP", "cryptix.openpgp.signature.PGPRevocationKeySP", "cryptix.openpgp.signature.PGPKeyIDSP", "cryptix.openpgp.signature.PGPNotationDataSP", "cryptix.openpgp.signature.PGPByteArraySP", "cryptix.openpgp.signature.PGPByteArraySP", "cryptix.openpgp.signature.PGPKeyServerPrefsSP", "cryptix.openpgp.signature.PGPStringSP", "cryptix.openpgp.signature.PGPBooleanSP", "cryptix.openpgp.signature.PGPStringSP", "cryptix.openpgp.signature.PGPKeyFlagsSP", "cryptix.openpgp.signature.PGPStringSP", "cryptix.openpgp.signature.PGPRevocationReasonSP", "cryptix.openpgp.signature.PGPFeaturesSP"};
    private static PGPSignatureSubPacketFactory defaultInstance = null;

    public PGPSignatureSubPacketFactory() {
        this(0);
    }

    public PGPSignatureSubPacketFactory(int init) {
        if ((init & 0xFF) == 0) {
            this.DefaultPackets();
        }
    }

    private void DefaultPackets() {
        try {
            int i = 0;
            while (i < defaultPacketIDs.length) {
                this.registerPacket(defaultPacketIDs[i], Class.forName(defaultPacketClasses[i]));
                ++i;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalError("Class not found for a default signature subpacket " + cnfe);
        }
    }

    public static PGPSignatureSubPacketFactory getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new PGPSignatureSubPacketFactory(0);
        }
        return defaultInstance;
    }

    public PGPSignatureSubPacket readPacket(InputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        PGPSignatureDataInputStream sdin = new PGPSignatureDataInputStream(in);
        int type = sdin.readUnsignedByte();
        boolean critical = (type & 0x80) != 0;
        type &= 0x7F;
        try {
            Class cl = (Class)this.PacketClasses.get(new Integer(type));
            if (cl != null) {
                PGPSignatureSubPacket packet = (PGPSignatureSubPacket)cl.newInstance();
                packet.setPacketID((byte)type);
                packet.decode(sdin);
                packet.setCritical(critical);
                return packet;
            }
            if (critical) {
                throw new PGPFatalDataFormatException("Unknown critical subpacket found in signature.");
            }
            PGPUnknownSP packet = new PGPUnknownSP();
            packet.setPacketID((byte)type);
            packet.decode(sdin);
            return packet;
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("The class for signature subpacket #" + type + " cannot be loaded. - " + ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("The class for signature subpacket #" + type + " cannot be loaded. - " + iae);
        }
    }

    public void registerPacket(int id, Class pktclass) {
        this.PacketClasses.put(new Integer(id), pktclass);
    }

    public void unregisterPacket(int id) {
        this.PacketClasses.remove(new Integer(id));
    }
}

