/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;

public class PGPMPI {
    private PGPMPI() {
    }

    public static BigInteger decode(DataInput in) throws IOException {
        int len = in.readUnsignedShort();
        byte[] buf = new byte[(len + 7) / 8];
        in.readFully(buf);
        return new BigInteger(1, buf);
    }

    public static void encode(DataOutput out, BigInteger x) throws IOException {
        out.writeShort(x.bitLength());
        byte[] bytes = x.toByteArray();
        if (bytes[0] == 0) {
            out.write(bytes, 1, bytes.length - 1);
        } else {
            out.write(bytes);
        }
    }

    public static byte[] toFixedLenByteArray(BigInteger x, int resultByteLen) {
        int x_off;
        if (x.signum() != 1) {
            throw new IllegalArgumentException("BigInteger not positive.");
        }
        byte[] x_bytes = x.toByteArray();
        int x_len = x_bytes.length;
        if (x_len <= 0) {
            throw new IllegalArgumentException("BigInteger too small.");
        }
        int n = x_off = x_bytes[0] == 0 ? 1 : 0;
        if ((x_len -= x_off) > resultByteLen) {
            throw new IllegalArgumentException("BigInteger too large.");
        }
        byte[] res_bytes = new byte[resultByteLen];
        int res_off = resultByteLen - x_len;
        System.arraycopy(x_bytes, x_off, res_bytes, res_off, x_len);
        return res_bytes;
    }
}

