/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message;

import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.message.SignedMessageBuilderSpi;
import cryptix.message.Support;
import cryptix.pki.KeyBundle;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;

public class SignedMessageBuilder {
    private final SignedMessageBuilderSpi spi;
    private final Provider provider;
    private final String format;

    protected SignedMessageBuilder(SignedMessageBuilderSpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final void addSigner(KeyBundle signingkey, char[] passphrase) throws IllegalStateException, MessageException, UnrecoverableKeyException {
        this.spi.engineAddSigner(signingkey, passphrase);
    }

    public final void addSigner(PrivateKey signingkey) throws IllegalStateException, MessageException {
        this.spi.engineAddSigner(signingkey);
    }

    public final Message build() throws IllegalStateException, MessageException {
        return this.spi.engineBuild();
    }

    public final String getFormat() {
        return this.format;
    }

    public static SignedMessageBuilder getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("SignedMessageBuilder", format);
        return new SignedMessageBuilder((SignedMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static SignedMessageBuilder getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("SignedMessageBuilder", format, provider);
        return new SignedMessageBuilder((SignedMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public static SignedMessageBuilder getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("SignedMessageBuilder", format, provider);
        return new SignedMessageBuilder((SignedMessageBuilderSpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Message contents) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents, new SecureRandom());
    }

    public final void init(Message contents, SecureRandom sr) throws IllegalStateException, MessageException {
        this.spi.engineInit(contents, sr);
    }

    public final void setAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageException {
        this.spi.engineSetAttribute(name, attr);
    }
}

