/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression.transformers;

import java.util.Collection;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.ExpressionConfig;

public class ExpressionArgument
implements MuleContextAware {
    private ExpressionConfig expressionConfig = new ExpressionConfig();
    private String name;
    private boolean optional;
    private Class returnClass;
    private MuleContext muleContext;

    public ExpressionArgument() {
    }

    public ExpressionArgument(String name, ExpressionConfig expressionConfig, boolean optional) {
        this(name, expressionConfig, optional, null);
    }

    public ExpressionArgument(String name, ExpressionConfig expressionConfig, boolean optional, Class returnClass) {
        this.expressionConfig = expressionConfig;
        this.name = name;
        this.optional = optional;
        this.returnClass = returnClass;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExpressionConfig getExpressionConfig() {
        return this.expressionConfig;
    }

    public void setExpressionConfig(ExpressionConfig expressionConfig) {
        this.expressionConfig = expressionConfig;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    protected String getFullExpression() {
        return this.expressionConfig.getFullExpression(this.muleContext.getExpressionManager());
    }

    protected void validate() {
        this.expressionConfig.validate(this.muleContext.getExpressionManager());
    }

    public Object evaluate(MuleMessage message) throws ExpressionRuntimeException {
        Object result = this.muleContext.getExpressionManager().evaluate(this.getExpression(), this.getEvaluator(), message, !this.isOptional());
        if (this.getReturnClass() != null && result != null) {
            if (!this.getReturnClass().isInstance(result)) {
                throw new ExpressionRuntimeException(CoreMessages.transformUnexpectedType(result.getClass(), this.getReturnClass()));
            }
            if (result instanceof Collection && ((Collection)result).size() == 0 && !this.isOptional()) {
                throw new ExpressionRuntimeException(CoreMessages.expressionEvaluatorReturnedNull(this.getEvaluator(), this.getExpression()));
            }
        }
        return result;
    }

    public String getExpression() {
        return this.expressionConfig.getExpression();
    }

    public void setExpression(String expression) {
        this.expressionConfig.setExpression(expression);
    }

    public String getEvaluator() {
        return this.expressionConfig.getEvaluator();
    }

    public void setEvaluator(String evaluator) {
        this.expressionConfig.setEvaluator(evaluator);
    }

    public void setCustomEvaluator(String evaluator) {
        this.expressionConfig.setCustomEvaluator(evaluator);
    }

    public String getCustomEvaluator() {
        return this.expressionConfig.getCustomEvaluator();
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(Class returnClass) {
        this.returnClass = returnClass;
    }
}

