/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEventContext;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.EntryPointNotFoundException;
import org.mule.util.CollectionUtils;

public class DefaultEntryPointResolverSet
implements EntryPointResolverSet {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set entryPointResolvers = new LinkedHashSet(4);
    private List exceptions = new CopyOnWriteArrayList();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object component, MuleEventContext context) throws Exception {
        try {
            Iterator iterator = this.entryPointResolvers.iterator();
            while (iterator.hasNext()) {
                EntryPointResolver resolver = (EntryPointResolver)iterator.next();
                InvocationResult result = resolver.invoke(component, context);
                if (result.getState() == 1) {
                    Object object = result.getResult();
                    Object var8_7 = null;
                    this.exceptions.clear();
                    return object;
                }
                if (!result.hasError()) continue;
                this.exceptions.add(result.getErrorMessage());
            }
            throw new EntryPointNotFoundException(CollectionUtils.toString((Collection)this.exceptions, true));
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.exceptions.clear();
            throw throwable;
        }
    }

    public Set getEntryPointResolvers() {
        return this.entryPointResolvers;
    }

    public void setEntryPointResolvers(Set entryPointResolvers) {
        this.entryPointResolvers.clear();
        this.entryPointResolvers.addAll(entryPointResolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntryPointResolver(EntryPointResolver resolver) {
        Set set = this.entryPointResolvers;
        synchronized (set) {
            this.entryPointResolvers.add(resolver);
        }
    }

    public boolean removeEntryPointResolver(EntryPointResolver resolver) {
        return this.entryPointResolvers.remove(resolver);
    }
}

