/*
 * Decompiled with CFR 0.152.
 */
package org.mule.object;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationCallback;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.object.ObjectFactory;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectFactory
implements ObjectFactory,
MuleContextAware {
    public static final String ATTRIBUTE_OBJECT_CLASS_NAME = "objectClassName";
    public static final String ATTRIBUTE_OBJECT_CLASS = "objectClass";
    protected String objectClassName;
    protected SoftReference<Class<?>> objectClass = null;
    protected Map properties = null;
    protected List initialisationCallbacks = new ArrayList();
    protected MuleContext muleContext;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public AbstractObjectFactory() {
    }

    public AbstractObjectFactory(String objectClassName) {
        this(objectClassName, null);
    }

    public AbstractObjectFactory(String objectClassName, Map properties) {
        this.objectClassName = objectClassName;
        this.properties = properties;
    }

    public AbstractObjectFactory(Class objectClass) {
        this(objectClass, null);
    }

    public AbstractObjectFactory(Class<?> objectClass, Map properties) {
        this.objectClass = new SoftReference(objectClass);
        this.properties = properties;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void initialise() throws InitialisationException {
        if ((this.objectClass == null || this.objectClass.get() == null) && this.objectClassName == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        if ((this.objectClass == null || this.objectClass.get() == null) && this.objectClassName != null) {
            try {
                this.objectClass = new SoftReference<Class>(ClassUtils.getClass((String)this.objectClassName));
            }
            catch (ClassNotFoundException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    @Override
    public void dispose() {
        this.objectClass.clear();
        this.objectClass.enqueue();
        this.objectClassName = null;
    }

    @Override
    public Object getInstance() throws Exception {
        if (this.objectClass == null || this.objectClass.get() == null) {
            throw new InitialisationException(MessageFactory.createStaticMessage("Object factory has not been initialized."), (Initialisable)this);
        }
        Object object = ClassUtils.instanciateClass(this.objectClass.get(), new Object[0]);
        if (this.properties != null) {
            BeanUtils.populateWithoutFail(object, this.properties, true);
        }
        this.fireInitialisationCallbacks(object);
        return object;
    }

    protected void fireInitialisationCallbacks(Object component) throws InitialisationException {
        for (InitialisationCallback callback : this.initialisationCallbacks) {
            callback.initialise(component);
        }
    }

    @Override
    public Class<?> getObjectClass() {
        return this.objectClass.get();
    }

    public void setObjectClass(Class<?> objectClass) {
        this.objectClass = new SoftReference(objectClass);
    }

    protected String getObjectClassName() {
        return this.objectClassName;
    }

    public void setObjectClassName(String objectClassName) {
        this.objectClassName = objectClassName;
    }

    protected Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    @Override
    public void addObjectInitialisationCallback(InitialisationCallback callback) {
        this.initialisationCallbacks.add(callback);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public boolean isExternallyManagedLifecycle() {
        return false;
    }
}

