/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.config.i18n.CoreMessages;
import org.mule.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegistry
implements Registry {
    private String id;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    protected AbstractRegistry(String id) {
        if (id == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("RegistryID"));
        }
        this.id = id;
    }

    @Override
    public final synchronized void dispose() {
        try {
            this.doDispose();
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to cleanly dispose: " + e.getMessage()), (Throwable)e);
        }
    }

    protected abstract void doInitialise() throws InitialisationException;

    protected abstract void doDispose();

    @Override
    public final void initialise() throws InitialisationException {
        if (this.id == null) {
            this.logger.warn((Object)"No unique id has been set on this registry");
            this.id = UUID.getUUID();
        }
        try {
            this.doInitialise();
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        Collection objects = this.lookupObjects(type);
        if (objects.size() == 1) {
            return (T)objects.iterator().next();
        }
        if (objects.size() > 1) {
            throw new RegistrationException("More than one object of type " + type + " registered but only one expected.");
        }
        return null;
    }

    @Override
    public final String getRegistryId() {
        return this.id;
    }
}

