/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.NamedObject;
import org.mule.api.agent.Agent;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.Model;
import org.mule.api.registry.AbstractServiceDescriptor;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.ServiceDescriptor;
import org.mule.api.registry.ServiceDescriptorFactory;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.TransformCriteria;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.service.Service;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.TypeBasedTransformerResolver;
import org.mule.util.SpiUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleRegistryHelper
implements MuleRegistry,
Initialisable,
Disposable {
    private DefaultRegistryBroker registry;
    protected Map<String, List<Transformer>> transformerListCache = new ConcurrentHashMap(8);
    protected transient Log logger = LogFactory.getLog(MuleRegistryHelper.class);

    public MuleRegistryHelper(DefaultRegistryBroker registry) {
        this.registry = registry;
    }

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        this.transformerListCache.clear();
    }

    @Override
    public Connector lookupConnector(String name) {
        return (Connector)this.registry.lookupObject(name);
    }

    public ImmutableEndpoint lookupEndpoint(String name) {
        Object obj = this.registry.lookupObject(name);
        if (obj instanceof ImmutableEndpoint) {
            return (ImmutableEndpoint)obj;
        }
        this.logger.debug((Object)("No endpoint with the name: " + name + "found.  If " + name + " is a global endpoint you should use the EndpointFactory to create endpoint instances from global endpoints."));
        return null;
    }

    @Override
    public EndpointBuilder lookupEndpointBuilder(String name) {
        Object o = this.registry.lookupObject(name);
        if (o instanceof EndpointBuilder) {
            this.logger.debug((Object)("Global endpoint EndpointBuilder for name: " + name + " found"));
            return (EndpointBuilder)o;
        }
        this.logger.debug((Object)("No endpoint builder with the name: " + name + " found."));
        return null;
    }

    @Override
    public EndpointFactory lookupEndpointFactory() {
        return (EndpointFactory)this.registry.lookupObject("_muleEndpointFactory");
    }

    @Override
    public Transformer lookupTransformer(String name) {
        return (Transformer)this.registry.lookupObject(name);
    }

    @Override
    public Transformer lookupTransformer(Class inputType, Class outputType) throws TransformerException {
        List resolvers = (List)this.lookupObjects(TransformerResolver.class);
        Collections.sort(resolvers, new TransformerResolverComarator());
        for (TransformerResolver resolver : resolvers) {
            try {
                Transformer trans = resolver.resolve(new TransformCriteria(new Class[]{inputType}, outputType, null, null));
                if (trans == null) continue;
                return trans;
            }
            catch (ResolverException e) {
                throw new TransformerException(CoreMessages.noTransformerFoundForMessage(inputType, outputType), (Throwable)e);
            }
        }
        throw new TransformerException(CoreMessages.noTransformerFoundForMessage(inputType, outputType));
    }

    @Override
    public List lookupTransformers(Class input, Class output) {
        List<Transformer> results = this.transformerListCache.get(input.getName() + output.getName());
        if (results != null) {
            return results;
        }
        results = new ArrayList<Transformer>(2);
        Collection transformers = this.getTransformers();
        for (Transformer t : transformers) {
            if (!(t instanceof DiscoverableTransformer)) continue;
            Class<Object> c = t.getReturnClass();
            if (c == null) {
                c = Object.class;
            }
            if (!output.isAssignableFrom(c) || !t.isSourceTypeSupported(input)) continue;
            results.add(t);
        }
        this.transformerListCache.put(input.getName() + output.getName(), results);
        return results;
    }

    @Override
    public Model lookupModel(String name) {
        return (Model)this.registry.lookupObject(name);
    }

    @Override
    public Model lookupSystemModel() {
        return this.lookupModel("_muleSystemModel");
    }

    @Override
    public Collection getModels() {
        return this.registry.lookupObjects(Model.class);
    }

    @Override
    public Collection getConnectors() {
        return this.registry.lookupObjects(Connector.class);
    }

    @Override
    public Collection getAgents() {
        return this.registry.lookupObjects(Agent.class);
    }

    @Override
    public Collection getEndpoints() {
        return this.registry.lookupObjects(ImmutableEndpoint.class);
    }

    @Override
    public Collection getTransformers() {
        return this.registry.lookupObjects(Transformer.class);
    }

    @Override
    public Agent lookupAgent(String name) {
        return (Agent)this.registry.lookupObject(name);
    }

    @Override
    public Service lookupService(String name) {
        return (Service)this.registry.lookupObject(name);
    }

    @Override
    public Collection<Service> lookupServices() {
        return this.lookupObjects(Service.class);
    }

    @Override
    public Collection<Service> lookupServices(String model) {
        Collection<Service> services = this.lookupServices();
        ArrayList<Service> modelServices = new ArrayList<Service>();
        for (Service service : services) {
            if (!model.equals(service.getModel().getName())) continue;
            modelServices.add(service);
        }
        return modelServices;
    }

    @Override
    public final void registerTransformer(Transformer transformer) throws MuleException {
        this.registry.registerObject(this.getName(transformer), transformer, Transformer.class);
        this.notifyTransformerResolvers(transformer, TransformerResolver.RegistryAction.ADDED);
    }

    protected void notifyTransformerResolvers(Transformer t, TransformerResolver.RegistryAction action) {
        if (t instanceof DiscoverableTransformer) {
            Collection resolvers = this.lookupObjects(TransformerResolver.class);
            for (TransformerResolver resolver : resolvers) {
                resolver.transformerChange(t, action);
            }
            this.transformerListCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceDescriptor lookupServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        String key = new AbstractServiceDescriptor.Key(name, overrides).getKey();
        ServiceDescriptor sd = (ServiceDescriptor)this.registry.lookupObject(key);
        MuleRegistryHelper muleRegistryHelper = this;
        synchronized (muleRegistryHelper) {
            if (sd == null) {
                sd = this.createServiceDescriptor(type, name, overrides);
                try {
                    this.registry.registerObject(key, sd, ServiceDescriptor.class);
                }
                catch (RegistrationException e) {
                    throw new ServiceException(e.getI18nMessage(), (Throwable)e);
                }
            }
        }
        return sd;
    }

    protected ServiceDescriptor createServiceDescriptor(String type, String name, Properties overrides) throws ServiceException {
        Properties props = SpiUtils.findServiceDescriptor(type, name);
        if (props == null) {
            throw new ServiceException(CoreMessages.failedToLoad(type + " " + name));
        }
        return ServiceDescriptorFactory.create(type, name, props, overrides, this, null);
    }

    @Override
    public void registerAgent(Agent agent) throws MuleException {
        this.registry.registerObject(this.getName(agent), agent, Agent.class);
    }

    @Override
    public void registerConnector(Connector connector) throws MuleException {
        this.registry.registerObject(this.getName(connector), connector, Connector.class);
    }

    @Override
    public void registerEndpoint(ImmutableEndpoint endpoint) throws MuleException {
        this.registry.registerObject(this.getName(endpoint), endpoint, ImmutableEndpoint.class);
    }

    @Override
    public void registerEndpointBuilder(String name, EndpointBuilder builder) throws MuleException {
        this.registry.registerObject(name, builder, EndpointBuilder.class);
    }

    @Override
    public void registerModel(Model model) throws MuleException {
        this.registry.registerObject(this.getName(model), model, Model.class);
    }

    @Override
    public void registerService(Service service) throws MuleException {
        this.registry.registerObject(this.getName(service), service, Service.class);
    }

    @Override
    public void unregisterService(String serviceName) throws MuleException {
        this.registry.unregisterObject(serviceName, Service.class);
    }

    @Override
    public void unregisterAgent(String agentName) throws MuleException {
        this.registry.unregisterObject(agentName, Agent.class);
    }

    @Override
    public void unregisterConnector(String connectorName) throws MuleException {
        this.registry.unregisterObject(connectorName, Connector.class);
    }

    @Override
    public void unregisterEndpoint(String endpointName) throws MuleException {
        this.registry.unregisterObject(endpointName, ImmutableEndpoint.class);
    }

    @Override
    public void unregisterModel(String modelName) throws MuleException {
        this.registry.unregisterObject(modelName, Model.class);
    }

    @Override
    public void unregisterTransformer(String transformerName) throws MuleException {
        Transformer transformer = this.lookupTransformer(transformerName);
        this.notifyTransformerResolvers(transformer, TransformerResolver.RegistryAction.REMOVED);
        this.registry.unregisterObject(transformerName, Transformer.class);
    }

    @Override
    public Object applyProcessorsAndLifecycle(Object object) throws MuleException {
        object = this.applyProcessors(object);
        object = this.applyLifecycle(object);
        return object;
    }

    @Override
    public Object applyProcessors(Object object) throws MuleException {
        return this.registry.getTransientRegistry().applyProcessors(object);
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        return this.registry.getTransientRegistry().applyLifecycle(object);
    }

    public Object lookupObject(Class type) throws RegistrationException {
        return this.registry.lookupObject(type);
    }

    @Override
    public Object lookupObject(String key) {
        return this.registry.lookupObject(key);
    }

    public Collection lookupObjects(Class type) {
        return this.registry.lookupObjects(type);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registry.registerObject(key, value, metadata);
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registry.registerObject(key, value);
    }

    public void registerObjects(Map objects) throws RegistrationException {
        this.registry.registerObjects(objects);
    }

    @Override
    public void unregisterObject(String key, Object metadata) throws RegistrationException {
        this.registry.unregisterObject(key, metadata);
    }

    @Override
    public void unregisterObject(String key) throws RegistrationException {
        this.registry.unregisterObject(key);
    }

    protected String getName(Object obj) {
        String name = null;
        if (obj instanceof NamedObject) {
            name = ((NamedObject)obj).getName();
        }
        if (StringUtils.isBlank(name)) {
            name = obj.getClass().getName() + ":" + UUID.getUUID();
        }
        return name;
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TransformerResolverComarator
    implements Comparator<TransformerResolver> {
        private TransformerResolverComarator() {
        }

        @Override
        public int compare(TransformerResolver transformerResolver, TransformerResolver transformerResolver1) {
            if (transformerResolver.getClass().equals(TypeBasedTransformerResolver.class)) {
                return 1;
            }
            if (transformerResolver1.getClass().equals(TypeBasedTransformerResolver.class)) {
                return -1;
            }
            return 0;
        }
    }
}

