/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformCriteria;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerChain;
import org.mule.transformer.TransformerWeighting;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.transformer.simple.ObjectToString;

public class TypeBasedTransformerResolver
implements TransformerResolver,
MuleContextAware,
Disposable,
Initialisable {
    protected final transient Log logger = LogFactory.getLog(TypeBasedTransformerResolver.class);
    private ObjectToString objectToString;
    private ObjectToByteArray objectToByteArray;
    private MuleContext muleContext;
    protected Map<String, Transformer> exactTransformerCache = new ConcurrentHashMap(8);

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        this.objectToString = new ObjectToString();
        this.objectToByteArray = new ObjectToByteArray();
    }

    public Transformer resolve(TransformCriteria criteria) throws ResolverException {
        Transformer result = this.exactTransformerCache.get(criteria.getInputTypes()[0].getName() + criteria.getOutputType().getName());
        if (result != null) {
            return result;
        }
        List trans = this.muleContext.getRegistry().lookupTransformers(criteria.getInputTypes()[0], criteria.getOutputType());
        result = this.getNearestTransformerMatch(trans, criteria.getInputTypes()[0], criteria.getOutputType());
        AbstractTransformer secondPass = null;
        if (result == null) {
            if (criteria.getOutputType().equals(String.class)) {
                secondPass = this.objectToString;
            } else if (criteria.getOutputType().equals(byte[].class)) {
                secondPass = this.objectToByteArray;
            } else {
                return null;
            }
            trans = this.muleContext.getRegistry().lookupTransformers(criteria.getInputTypes()[0], Object.class);
            result = this.getNearestTransformerMatch(trans, criteria.getInputTypes()[0], criteria.getOutputType());
            if (result != null) {
                result = new TransformerChain(result, secondPass);
            }
        }
        if (result != null) {
            this.exactTransformerCache.put(criteria.getInputTypes()[0].getName() + criteria.getOutputType().getName(), result);
        }
        return result;
    }

    protected Transformer getNearestTransformerMatch(List trans, Class input, Class output) throws ResolverException {
        if (trans.size() > 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Comparing transformers for best match: input = " + input + " output = " + output + " Possible transformers = " + trans));
            }
            TransformerWeighting weighting = null;
            for (Transformer transformer : trans) {
                TransformerWeighting current = new TransformerWeighting(input, output, transformer);
                if (weighting == null) {
                    weighting = current;
                    continue;
                }
                int compare = current.compareTo(weighting);
                if (compare == 1) {
                    weighting = current;
                    continue;
                }
                if (compare != 0 || weighting.getTransformer().getClass().equals(current.getTransformer().getClass())) continue;
                throw new ResolverException(CoreMessages.transformHasMultipleMatches(input, output, current.getTransformer(), weighting.getTransformer()));
            }
            return weighting.getTransformer();
        }
        if (trans.size() == 0) {
            return null;
        }
        return (Transformer)trans.get(0);
    }

    public void dispose() {
        this.exactTransformerCache.clear();
    }

    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
        if (transformer instanceof DiscoverableTransformer) {
            this.exactTransformerCache.clear();
        }
    }
}

