/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.binding;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.InterfaceBinding;
import org.mule.api.routing.OutboundRouter;
import org.mule.config.i18n.CoreMessages;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.AbstractRouter;
import org.mule.routing.binding.BindingInvocationHandler;
import org.mule.routing.outbound.OutboundPassThroughRouter;

public class DefaultInterfaceBinding
extends AbstractRouter
implements InterfaceBinding {
    protected static final Log logger = LogFactory.getLog(DefaultInterfaceBinding.class);
    private Class interfaceClass;
    private String methodName;
    protected OutboundRouter outboundRouter;

    public DefaultInterfaceBinding() {
        this.setRouterStatistics(new RouterStatistics(4));
    }

    public MuleMessage route(MuleMessage message, MuleSession session) throws MessagingException {
        return this.outboundRouter.route(message, session);
    }

    public void setInterface(Class interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public Class getInterface() {
        return this.interfaceClass;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public Object createProxy(Object target) {
        try {
            Object proxy = Proxy.newProxyInstance(this.getInterface().getClassLoader(), new Class[]{this.getInterface()}, (InvocationHandler)new BindingInvocationHandler(this));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Have proxy?: " + (null != proxy)));
            }
            return proxy;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(CoreMessages.failedToCreateProxyFor(target), (Throwable)e);
        }
    }

    public void setEndpoint(ImmutableEndpoint e) {
        if (!(e instanceof OutboundEndpoint)) {
            throw new IllegalArgumentException("An outbound endpoint is required for Interface binding");
        }
        this.outboundRouter = new OutboundPassThroughRouter();
        this.outboundRouter.addEndpoint((OutboundEndpoint)e);
        this.outboundRouter.setTransactionConfig(e.getTransactionConfig());
    }

    public Class getInterfaceClass() {
        return this.interfaceClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DefaultInterfaceBinding");
        sb.append("{method='").append(this.methodName).append('\'');
        sb.append(", interface=").append(this.interfaceClass);
        sb.append('}');
        return sb.toString();
    }

    public ImmutableEndpoint getEndpoint() {
        if (this.outboundRouter != null) {
            return (OutboundEndpoint)this.outboundRouter.getEndpoints().get(0);
        }
        return null;
    }
}

