/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.inbound;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.routing.RoutingException;
import org.mule.api.transformer.TransformerException;
import org.mule.routing.inbound.IdempotentReceiver;
import org.mule.transformer.simple.ByteArrayToHexString;
import org.mule.transformer.simple.SerializableToByteArray;

public class IdempotentSecureHashReceiver
extends IdempotentReceiver {
    private String messageDigestAlgorithm = "SHA-256";
    private final SerializableToByteArray objectToByteArray = new SerializableToByteArray();
    private final ByteArrayToHexString byteArrayToHexString = new ByteArrayToHexString();

    protected String getIdForEvent(MuleEvent event) throws MessagingException {
        try {
            MessageDigest md = MessageDigest.getInstance(this.messageDigestAlgorithm);
            return (String)this.byteArrayToHexString.transform(md.digest((byte[])this.objectToByteArray.transform(event.getMessage().getPayload())));
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)nsa);
        }
        catch (TransformerException te) {
            throw new RoutingException(event.getMessage(), event.getEndpoint(), (Throwable)te);
        }
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }
}

