/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;

public abstract class AbstractMessageAwareTransformer
extends AbstractTransformer {
    public boolean isSourceTypeSupported(Class aClass, boolean exactMatch) {
        return super.isSourceTypeSupported(aClass, exactMatch) || MuleMessage.class.isAssignableFrom(aClass);
    }

    public final Object doTransform(Object src, String encoding) throws TransformerException {
        MuleMessage message;
        if (src instanceof MuleMessage) {
            message = (MuleMessage)src;
        } else if (this.muleContext.getConfiguration().isAutoWrapMessageAwareTransform()) {
            message = new DefaultMuleMessage(src, this.muleContext);
        } else {
            MuleEventContext event = RequestContext.getEventContext();
            if (event == null) {
                throw new TransformerException(CoreMessages.noCurrentEventForTransformer(), this);
            }
            message = event.getMessage();
            if (!message.getPayload().equals(src)) {
                throw new IllegalStateException("Transform payload does not match current MuleEventContext payload");
            }
        }
        return this.transform(message, encoding);
    }

    public abstract Object transform(MuleMessage var1, String var2) throws TransformerException;
}

