/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.IOUtils;

public class ObjectToOutputHandler
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 2;

    public ObjectToOutputHandler() {
        this.registerSourceType(byte[].class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(Serializable.class);
        this.setReturnClass(OutputHandler.class);
    }

    public Object doTransform(final Object src, final String encoding) throws TransformerException {
        if (src instanceof String) {
            return new OutputHandler(){

                public void write(MuleEvent event, OutputStream out) throws IOException {
                    out.write(((String)src).getBytes(encoding));
                }
            };
        }
        if (src instanceof byte[]) {
            return new OutputHandler(){

                public void write(MuleEvent event, OutputStream out) throws IOException {
                    out.write((byte[])src);
                }
            };
        }
        if (src instanceof InputStream) {
            return new OutputHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(MuleEvent event, OutputStream out) throws IOException {
                    InputStream is = (InputStream)src;
                    try {
                        IOUtils.copyLarge((InputStream)is, (OutputStream)out);
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
            };
        }
        if (src instanceof Serializable) {
            return new OutputHandler(){

                public void write(MuleEvent event, OutputStream out) throws IOException {
                    SerializationUtils.serialize((Serializable)((Serializable)src), (OutputStream)out);
                }
            };
        }
        throw new TransformerException(MessageFactory.createStaticMessage("Unable to convert " + src.getClass() + " to OutputHandler."));
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

