/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import org.mule.util.StringUtils;

public class NamedThreadFactory
implements ThreadFactory {
    private final String name;
    private final AtomicLong counter;
    private final ClassLoader contextClassLoader;

    public NamedThreadFactory(String name) {
        this(name, null);
    }

    public NamedThreadFactory(String name, ClassLoader contextClassLoader) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("NamedThreadFactory must have a proper name.");
        }
        this.name = name;
        this.contextClassLoader = contextClassLoader;
        this.counter = new AtomicLong(1L);
    }

    public Thread newThread(Runnable runnable) {
        Thread t = new Thread(runnable);
        this.configureThread(t);
        return t;
    }

    protected void configureThread(Thread t) {
        if (this.contextClassLoader != null) {
            t.setContextClassLoader(this.contextClassLoader);
        }
        this.doConfigureThread(t);
    }

    protected void doConfigureThread(Thread t) {
        t.setName(this.name + '.' + this.counter.getAndIncrement());
    }
}

