/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.ConfigUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class FormLoginBeanDefinitionParser
implements BeanDefinitionParser {
    protected final Log logger = LogFactory.getLog(this.getClass());
    static final String ATT_LOGIN_URL = "login-processing-url";
    static final String ATT_LOGIN_PAGE = "login-page";
    static final String DEF_LOGIN_PAGE = "/spring_security_login";
    static final String ATT_FORM_LOGIN_TARGET_URL = "default-target-url";
    static final String ATT_ALWAYS_USE_DEFAULT_TARGET_URL = "always-use-default-target";
    static final String DEF_FORM_LOGIN_TARGET_URL = "/";
    static final String ATT_FORM_LOGIN_AUTHENTICATION_FAILURE_URL = "authentication-failure-url";
    static final String DEF_FORM_LOGIN_AUTHENTICATION_FAILURE_URL = "/spring_security_login?login_error";
    String defaultLoginProcessingUrl;
    String filterClassName;
    RootBeanDefinition filterBean;
    RootBeanDefinition entryPointBean;
    String loginPage;
    static /* synthetic */ Class class$org$springframework$security$ui$webapp$AuthenticationProcessingFilterEntryPoint;

    FormLoginBeanDefinitionParser(String defaultLoginProcessingUrl, String filterClassName) {
        this.defaultLoginProcessingUrl = defaultLoginProcessingUrl;
        this.filterClassName = filterClassName;
    }

    public BeanDefinition parse(Element elt, ParserContext pc) {
        String loginUrl = null;
        String defaultTargetUrl = null;
        String authenticationFailureUrl = null;
        String alwaysUseDefault = null;
        Object source = null;
        Boolean sessionFixationProtectionEnabled = new Boolean(pc.getRegistry().containsBeanDefinition("_sessionFixationProtectionFilter"));
        Boolean migrateSessionAttributes = Boolean.FALSE;
        if (sessionFixationProtectionEnabled.booleanValue()) {
            PropertyValue pv = pc.getRegistry().getBeanDefinition("_sessionFixationProtectionFilter").getPropertyValues().getPropertyValue("migrateSessionAttributes");
            migrateSessionAttributes = (Boolean)pv.getValue();
        }
        if (elt != null) {
            source = pc.extractSource((Object)elt);
            loginUrl = elt.getAttribute(ATT_LOGIN_URL);
            ConfigUtils.validateHttpRedirect(loginUrl, pc, source);
            defaultTargetUrl = elt.getAttribute(ATT_FORM_LOGIN_TARGET_URL);
            ConfigUtils.validateHttpRedirect(defaultTargetUrl, pc, source);
            authenticationFailureUrl = elt.getAttribute(ATT_FORM_LOGIN_AUTHENTICATION_FAILURE_URL);
            ConfigUtils.validateHttpRedirect(authenticationFailureUrl, pc, source);
            alwaysUseDefault = elt.getAttribute(ATT_ALWAYS_USE_DEFAULT_TARGET_URL);
            this.loginPage = elt.getAttribute(ATT_LOGIN_PAGE);
            if (!StringUtils.hasText((String)this.loginPage)) {
                this.loginPage = null;
            }
            ConfigUtils.validateHttpRedirect(this.loginPage, pc, source);
        }
        ConfigUtils.registerProviderManagerIfNecessary(pc);
        this.filterBean = this.createFilterBean(loginUrl, defaultTargetUrl, alwaysUseDefault, this.loginPage, authenticationFailureUrl);
        this.filterBean.setSource(source);
        this.filterBean.getPropertyValues().addPropertyValue("authenticationManager", (Object)new RuntimeBeanReference("_authenticationManager"));
        this.filterBean.getPropertyValues().addPropertyValue("invalidateSessionOnSuccessfulAuthentication", (Object)sessionFixationProtectionEnabled);
        this.filterBean.getPropertyValues().addPropertyValue("migrateInvalidatedSessionAttributes", (Object)migrateSessionAttributes);
        if (pc.getRegistry().containsBeanDefinition("_rememberMeServices")) {
            this.filterBean.getPropertyValues().addPropertyValue("rememberMeServices", (Object)new RuntimeBeanReference("_rememberMeServices"));
        }
        if (pc.getRegistry().containsBeanDefinition("_sessionRegistry")) {
            this.filterBean.getPropertyValues().addPropertyValue("sessionRegistry", (Object)new RuntimeBeanReference("_sessionRegistry"));
        }
        BeanDefinitionBuilder entryPointBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)(class$org$springframework$security$ui$webapp$AuthenticationProcessingFilterEntryPoint == null ? (class$org$springframework$security$ui$webapp$AuthenticationProcessingFilterEntryPoint = FormLoginBeanDefinitionParser.class$("org.springframework.security.ui.webapp.AuthenticationProcessingFilterEntryPoint")) : class$org$springframework$security$ui$webapp$AuthenticationProcessingFilterEntryPoint));
        entryPointBuilder.setSource(source);
        entryPointBuilder.addPropertyValue("loginFormUrl", (Object)(this.loginPage != null ? this.loginPage : DEF_LOGIN_PAGE));
        this.entryPointBean = (RootBeanDefinition)entryPointBuilder.getBeanDefinition();
        return null;
    }

    private RootBeanDefinition createFilterBean(String loginUrl, String defaultTargetUrl, String alwaysUseDefault, String loginPage, String authenticationFailureUrl) {
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)this.filterClassName);
        if (!StringUtils.hasText((String)loginUrl)) {
            loginUrl = this.defaultLoginProcessingUrl;
        }
        if ("true".equals(alwaysUseDefault)) {
            filterBuilder.addPropertyValue("alwaysUseDefaultTargetUrl", (Object)Boolean.TRUE);
        }
        filterBuilder.addPropertyValue("filterProcessesUrl", (Object)loginUrl);
        if (!StringUtils.hasText((String)defaultTargetUrl)) {
            defaultTargetUrl = DEF_FORM_LOGIN_TARGET_URL;
        }
        filterBuilder.addPropertyValue("defaultTargetUrl", (Object)defaultTargetUrl);
        if (!StringUtils.hasText((String)authenticationFailureUrl)) {
            authenticationFailureUrl = StringUtils.hasText((String)loginPage) ? loginPage : DEF_FORM_LOGIN_AUTHENTICATION_FAILURE_URL;
        }
        filterBuilder.addPropertyValue("authenticationFailureUrl", (Object)authenticationFailureUrl);
        return (RootBeanDefinition)filterBuilder.getBeanDefinition();
    }

    RootBeanDefinition getFilterBean() {
        return this.filterBean;
    }

    RootBeanDefinition getEntryPointBean() {
        return this.entryPointBean;
    }

    String getLoginPage() {
        return this.loginPage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

