/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import net.sf.saxon.Configuration;
import net.sf.saxon.javax.xml.xquery.XQCommonHandler;
import net.sf.saxon.javax.xml.xquery.XQConnection;
import net.sf.saxon.javax.xml.xquery.XQException;
import net.sf.saxon.javax.xml.xquery.XQItem;
import net.sf.saxon.javax.xml.xquery.XQPreparedExpression;
import net.sf.saxon.javax.xml.xquery.XQResultSequence;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.DocumentSource;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.i18n.XmlMessages;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.util.IOUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XQueryTransformer
extends AbstractXmlTransformer
implements Disposable {
    public static final String SOURCE_DOCUMENT_NAMESPACE = "document";
    private static final int MIN_IDLE_TRANSFORMERS = 1;
    private static final int MAX_IDLE_TRANSFORMERS = 32;
    private static final int MAX_ACTIVE_TRANSFORMERS = 32;
    protected final GenericObjectPool transformerPool = new GenericObjectPool((PoolableObjectFactory)new PooledXQueryTransformerFactory());
    private volatile String xqueryFile;
    private volatile String xquery;
    private volatile Map contextProperties;
    private volatile XQCommonHandler commonHandler;
    private volatile XQConnection connection;
    protected Configuration configuration;

    public XQueryTransformer() {
        this.transformerPool.setMinIdle(1);
        this.transformerPool.setMaxIdle(32);
        this.transformerPool.setMaxActive(32);
        this.registerSourceType(String.class);
        this.registerSourceType(byte[].class);
        this.registerSourceType(DocumentSource.class);
        this.registerSourceType(Document.class);
        this.registerSourceType(org.w3c.dom.Document.class);
        this.registerSourceType(Element.class);
        this.registerSourceType(InputStream.class);
        this.setReturnClass(Element.class);
    }

    public XQueryTransformer(String xqueryFile) {
        this();
        this.xqueryFile = xqueryFile;
    }

    public void initialise() throws InitialisationException {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        try {
            SaxonXQDataSource ds = new SaxonXQDataSource(this.configuration);
            if (this.commonHandler != null) {
                ds.setCommonHandler(this.commonHandler);
            }
            this.connection = ds.getConnection();
            this.transformerPool.addObject();
        }
        catch (Throwable te) {
            throw new InitialisationException(te, (Initialisable)this);
        }
    }

    public void dispose() {
        try {
            this.connection.close();
        }
        catch (XQException e) {
            this.logger.warn((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object transform(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            XQPreparedExpression transformer = null;
            try {
                Object object;
                transformer = (XQPreparedExpression)this.transformerPool.borrowObject();
                this.bindParameters(transformer, message);
                this.bindDocument(message.getPayload(), transformer);
                XQResultSequence result = transformer.executeQuery();
                ArrayList<Object> results = new ArrayList<Object>();
                while (result.next()) {
                    XQItem item = result.getItem();
                    if (Node.class.isAssignableFrom(this.returnClass) || Node[].class.isAssignableFrom(this.returnClass)) {
                        results.add(item.getNode());
                    } else if (String.class.isAssignableFrom(this.returnClass) || String[].class.isAssignableFrom(this.returnClass)) {
                        results.add(item.getItemAsString());
                    } else {
                        if (XMLStreamReader.class.isAssignableFrom(this.returnClass) || XMLStreamReader[].class.isAssignableFrom(this.returnClass)) {
                            try {
                                results.add(item.getItemAsStream());
                            }
                            catch (XQException e) {
                                throw new TransformerException(XmlMessages.streamNotAvailble(this.getName()));
                            }
                        }
                        try {
                            results.add(item.getObject());
                        }
                        catch (XQException e) {
                            throw new TransformerException(XmlMessages.objectNotAvailble(this.getName()));
                        }
                    }
                    if (this.returnClass.isArray()) continue;
                }
                if (this.returnClass.isArray()) {
                    object = results.toArray();
                    return object;
                }
                if (results.size() == 1) {
                    object = results.get(0);
                    return object;
                }
                if (results.size() == 0) {
                    object = null;
                    return object;
                }
                object = results.toArray();
                return object;
            }
            finally {
                if (transformer != null) {
                    if (transformer.getWarnings() != null) {
                        this.logger.warn((Object)transformer.getWarnings().getMessage(), transformer.getWarnings().fillInStackTrace());
                    }
                    this.transformerPool.returnObject((Object)transformer);
                }
            }
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected void bindParameters(XQPreparedExpression transformer, MuleMessage message) throws XQException, TransformerException {
        if (this.contextProperties != null) {
            for (Map.Entry parameter : this.contextProperties.entrySet()) {
                String key = (String)parameter.getKey();
                Object o = this.evaluateTransformParameter(key, parameter.getValue(), message);
                if (o instanceof String) {
                    transformer.bindAtomicValue(new QName(key), o.toString(), this.connection.createAtomicItemType(30));
                    continue;
                }
                if (o instanceof Boolean) {
                    transformer.bindBoolean(new QName(key), ((Boolean)o).booleanValue(), this.connection.createAtomicItemType(11));
                    continue;
                }
                if (o instanceof Byte) {
                    transformer.bindByte(new QName(key), ((Byte)o).byteValue(), this.connection.createAtomicItemType(32));
                    continue;
                }
                if (o instanceof Short) {
                    transformer.bindShort(new QName(key), ((Short)o).shortValue(), this.connection.createAtomicItemType(15));
                    continue;
                }
                if (o instanceof Integer) {
                    transformer.bindInt(new QName(key), ((Integer)o).intValue(), this.connection.createAtomicItemType(13));
                    continue;
                }
                if (o instanceof Long) {
                    transformer.bindLong(new QName(key), ((Long)o).longValue(), this.connection.createAtomicItemType(16));
                    continue;
                }
                if (o instanceof Float) {
                    transformer.bindFloat(new QName(key), ((Float)o).floatValue(), this.connection.createAtomicItemType(21));
                    continue;
                }
                if (o instanceof Double) {
                    transformer.bindDouble(new QName(key), ((Double)o).doubleValue(), this.connection.createAtomicItemType(19));
                    continue;
                }
                this.logger.error((Object)("Cannot bind value: " + o + " cannot be bound to the Xquery context. Not of supported type"));
            }
        }
    }

    protected void bindDocument(Object src, XQPreparedExpression transformer) throws XQException, TransformerException {
        if (src instanceof byte[]) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), new InputSource(new ByteArrayInputStream((byte[])src)));
        } else if (src instanceof InputStream) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), new InputSource((InputStream)src));
        } else if (src instanceof String) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), new InputSource(new StringReader((String)src)));
        } else if (src instanceof org.w3c.dom.Document) {
            transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), (Node)((org.w3c.dom.Document)src), null);
        } else if (src instanceof Element) {
            transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), (Node)((Element)src), null);
        } else if (src instanceof Document) {
            try {
                DOMWriter domWriter = new DOMWriter();
                org.w3c.dom.Document dom = domWriter.write((Document)src);
                transformer.bindNode(new QName(SOURCE_DOCUMENT_NAMESPACE), (Node)dom, null);
            }
            catch (DocumentException e) {
                throw new TransformerException(this, (Throwable)e);
            }
        } else if (src instanceof DocumentSource) {
            transformer.bindDocument(new QName(SOURCE_DOCUMENT_NAMESPACE), ((DocumentSource)src).getInputSource());
        } else {
            throw new TransformerException(CoreMessages.transformUnexpectedType(src.getClass(), null), this);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getXqueryFile() {
        return this.xqueryFile;
    }

    public void setXqueryFile(String xqueryFile) {
        this.xqueryFile = xqueryFile;
    }

    public String getXquery() {
        return this.xquery;
    }

    public void setXquery(String xquery) {
        this.xquery = xquery;
    }

    public XQCommonHandler getCommonHandler() {
        return this.commonHandler;
    }

    public void setCommonHandler(XQCommonHandler commonHandler) {
        this.commonHandler = commonHandler;
    }

    public int getMaxActiveTransformers() {
        return this.transformerPool.getMaxActive();
    }

    public void setMaxActiveTransformers(int maxActiveTransformers) {
        this.transformerPool.setMaxActive(maxActiveTransformers);
    }

    public int getMaxIdleTransformers() {
        return this.transformerPool.getMaxIdle();
    }

    public void setMaxIdleTransformers(int maxIdleTransformers) {
        this.transformerPool.setMaxIdle(maxIdleTransformers);
    }

    public Map getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map contextProperties) {
        this.contextProperties = contextProperties;
    }

    protected Object evaluateTransformParameter(String name, Object value, MuleMessage message) throws TransformerException {
        if (value instanceof String) {
            return this.muleContext.getExpressionManager().parse(value.toString(), message);
        }
        return value;
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        try {
            ((Initialisable)clone).initialise();
            return clone;
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(CoreMessages.failedToClone(this.getClass().getName()), (Throwable)e);
        }
    }

    protected class PooledXQueryTransformerFactory
    extends BasePoolableObjectFactory {
        protected PooledXQueryTransformerFactory() {
        }

        public Object makeObject() throws Exception {
            if (XQueryTransformer.this.xqueryFile != null) {
                XQueryTransformer.this.xquery = IOUtils.getResourceAsString(XQueryTransformer.this.xqueryFile, ((Object)((Object)this)).getClass());
            }
            return XQueryTransformer.this.connection.prepareExpression(XQueryTransformer.this.xquery);
        }

        public void destroyObject(Object o) throws Exception {
            ((XQPreparedExpression)o).close();
            super.destroyObject(o);
        }
    }
}

