/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.component.JavaComponent;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.service.Service;
import org.mule.api.transport.MessageAdapter;
import org.mule.config.ExceptionHelper;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.soap.axis.extras.AxisCleanAndAddProperties;
import org.mule.util.ClassUtils;

public class AxisServiceProxy {
    private static ThreadLocal properties = new ThreadLocal();

    public static Object createProxy(AbstractMessageReceiver receiver, boolean synchronous, Class[] classes) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return Proxy.newProxyInstance(cl, classes, AxisServiceProxy.createServiceHandler(receiver, synchronous));
    }

    public static InvocationHandler createServiceHandler(AbstractMessageReceiver receiver, boolean synchronous) {
        return new AxisServiceHandler(receiver, synchronous);
    }

    public static void setProperties(Map properties) {
        AxisServiceProxy.properties.set(properties);
    }

    public static Class[] getInterfacesForComponent(Service service) throws MuleException, ClassNotFoundException {
        Class[] interfaces;
        List ifaces = null;
        Map localProperties = (Map)properties.get();
        if (null != localProperties) {
            ifaces = (List)localProperties.get("serviceInterfaces");
        }
        if (ifaces == null || ifaces.size() == 0) {
            Class implementationClass;
            if (service.getComponent() instanceof JavaComponent) {
                try {
                    implementationClass = ((JavaComponent)service.getComponent()).getObjectType();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException("Unable to retrieve class from service factory", e);
                }
            } else {
                throw new ClassNotFoundException("Unable to retrieve class from service factory");
            }
            List intfList = ClassUtils.getAllInterfaces((Class)implementationClass);
            interfaces = intfList.toArray(new Class[intfList.size()]);
        } else {
            interfaces = new Class[ifaces.size()];
            for (int i = 0; i < ifaces.size(); ++i) {
                String iface = (String)ifaces.get(i);
                interfaces[i] = ClassUtils.loadClass((String)iface, AxisServiceProxy.class);
            }
        }
        interfaces = AxisServiceProxy.removeInterface(interfaces, Callable.class);
        interfaces = AxisServiceProxy.removeInterface(interfaces, Disposable.class);
        interfaces = AxisServiceProxy.removeInterface(interfaces, Initialisable.class);
        return interfaces;
    }

    public static Class[] removeInterface(Class[] interfaces, Class iface) {
        if (interfaces == null) {
            return null;
        }
        ArrayList<Class> results = new ArrayList<Class>();
        for (int i = 0; i < interfaces.length; ++i) {
            Class anInterface = interfaces[i];
            if (anInterface.equals(iface)) continue;
            results.add(anInterface);
        }
        Class[] arResults = new Class[results.size()];
        if (arResults.length == 0) {
            return arResults;
        }
        results.toArray(arResults);
        return arResults;
    }

    public static Method[] getMethods(Class[] interfaces) {
        ArrayList<Method> methodNames = new ArrayList<Method>();
        for (int i = 0; i < interfaces.length; ++i) {
            methodNames.addAll(Arrays.asList(interfaces[i].getMethods()));
        }
        Method[] results = new Method[methodNames.size()];
        return methodNames.toArray(results);
    }

    public static String[] getMethodNames(Class[] interfaces) {
        Method[] methods = AxisServiceProxy.getMethods(interfaces);
        String[] results = new String[methods.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = methods[i].getName();
        }
        return results;
    }

    private static class AxisServiceHandler
    implements InvocationHandler {
        private AbstractMessageReceiver receiver;
        private boolean synchronous = true;

        public AxisServiceHandler(AbstractMessageReceiver receiver, boolean synchronous) {
            this.receiver = receiver;
            this.synchronous = synchronous;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            MessageAdapter messageAdapter = this.receiver.getConnector().getMessageAdapter((Object)args);
            messageAdapter.setProperty("method", (Object)method);
            messageAdapter.addProperties(AxisCleanAndAddProperties.cleanAndAdd(RequestContext.getEventContext()));
            MuleMessage message = this.receiver.routeMessage((MuleMessage)new DefaultMuleMessage((Object)messageAdapter, this.receiver.getConnector().getMuleContext()), this.synchronous);
            if (message != null) {
                ExceptionPayload wsException = message.getExceptionPayload();
                if (wsException != null) {
                    MuleException exception = ExceptionHelper.getRootMuleException((Throwable)wsException.getException());
                    if (exception.getCause() != null) {
                        throw exception.getCause();
                    }
                    throw exception;
                }
                return message.getPayload();
            }
            return null;
        }
    }
}

