/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.type;

import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaType {
    protected final Class<?> _class;
    protected int _hashCode;
    Object _handler;

    protected JavaType(Class<?> clz) {
        this._class = clz;
        String name = clz.getName();
        this._hashCode = name.hashCode();
    }

    public final JavaType narrowBy(Class<?> subclass) {
        if (subclass == this._class) {
            return this;
        }
        this._assertSubclass(subclass, this._class);
        JavaType result = this._narrow(subclass);
        if (this._handler != null) {
            result.setHandler(this._handler);
        }
        return result;
    }

    public final JavaType widenBy(Class<?> superclass) {
        if (superclass == this._class) {
            return this;
        }
        this._assertSubclass(this._class, superclass);
        return this._widen(superclass);
    }

    protected abstract JavaType _narrow(Class<?> var1);

    protected JavaType _widen(Class<?> superclass) {
        return this._narrow(superclass);
    }

    public abstract JavaType narrowContentsBy(Class<?> var1);

    public void setHandler(Object h) {
        if (h != null && this._handler != null) {
            throw new IllegalStateException("Trying to reset handler for type [" + this.toString() + "]; old handler of type " + this._handler.getClass().getName() + ", new handler of type " + h.getClass().getName());
        }
        this._handler = h;
    }

    public final Class<?> getRawClass() {
        return this._class;
    }

    public final boolean hasRawClass(Class<?> clz) {
        return this._class == clz;
    }

    public abstract boolean isContainerType();

    public final boolean isAbstract() {
        return Modifier.isAbstract(this._class.getModifiers());
    }

    public boolean isConcrete() {
        int mod = this._class.getModifiers();
        return (mod & 0x600) == 0;
    }

    public boolean isThrowable() {
        return Throwable.class.isAssignableFrom(this._class);
    }

    public final boolean isArrayType() {
        return this._class.isArray();
    }

    public final boolean isEnumType() {
        return this._class.isEnum();
    }

    public final boolean isInterface() {
        return this._class.isInterface();
    }

    public final boolean isPrimitive() {
        return this._class.isPrimitive();
    }

    public JavaType findVariableType(String name) {
        return null;
    }

    public JavaType getKeyType() {
        return null;
    }

    public JavaType getContentType() {
        return null;
    }

    public Object getHandler() {
        return this._handler;
    }

    protected void _assertSubclass(Class<?> subclass, Class<?> superClass) {
        if (!this._class.isAssignableFrom(subclass)) {
            throw new IllegalArgumentException("Class " + subclass.getName() + " is not assignable to " + this._class.getName());
        }
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public final int hashCode() {
        return this._hashCode;
    }
}

