/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.json.JsonData;
import org.mule.util.NumberUtils;

public class JsonExpressionEvaluator
implements ExpressionEvaluator {
    protected final transient Log logger = LogFactory.getLog(JsonExpressionEvaluator.class);

    public Object evaluate(String expression, MuleMessage message) {
        int i;
        String compareTo = null;
        boolean not = false;
        int start = expression.lastIndexOf("/");
        if (start == -1) {
            start = 0;
        }
        if ((i = expression.indexOf("==", start)) > -1) {
            compareTo = expression.substring(i + 2, expression.length()).trim();
            expression = expression.substring(0, i).trim();
        } else {
            i = expression.indexOf("!=", start);
            if (i > -1) {
                compareTo = expression.substring(i + 2, expression.length()).trim();
                expression = expression.substring(0, i).trim();
                not = true;
            }
        }
        try {
            JsonData data = message.getPayload(JsonData.class);
            try {
                Object result = data.get(expression);
                if (compareTo != null) {
                    if (compareTo.equalsIgnoreCase("null")) {
                        boolean answer;
                        boolean bl = answer = result == null;
                        return not ? !answer : answer;
                    }
                    if (result instanceof Number && NumberUtils.isDigits((String)compareTo)) {
                        boolean answer = NumberUtils.createNumber((String)compareTo).equals(result);
                        return not ? !answer : answer;
                    }
                    if (result instanceof Boolean && (compareTo.equalsIgnoreCase("true") || compareTo.equalsIgnoreCase("false"))) {
                        boolean answer = result.equals(Boolean.valueOf(compareTo));
                        return not ? !answer : answer;
                    }
                    boolean answer = compareTo.equals(result);
                    return not ? !answer : answer;
                }
                return result;
            }
            catch (IllegalArgumentException e) {
                this.logger.debug((Object)("returning null for json expression: " + expression + ": " + e.getMessage()));
                return null;
            }
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException(CoreMessages.failedToProcessExtractorFunction(this.getName() + ":" + expression), (Throwable)e);
        }
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("setName");
    }

    public String getName() {
        return "json";
    }
}

