/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp.filters;

import cryptix.message.LiteralMessage;
import cryptix.message.Message;
import cryptix.message.MessageFactory;
import cryptix.message.SignedMessage;
import cryptix.pki.KeyBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.PGPAuthentication;
import org.mule.module.pgp.PGPCryptInfo;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.security.AbstractEndpointSecurityFilter;

public class PGPSecurityFilter
extends AbstractEndpointSecurityFilter {
    protected static final Log logger = LogFactory.getLog(PGPSecurityFilter.class);
    private EncryptionStrategy strategy;
    private String strategyName;
    private boolean signRequired;
    private PGPKeyRing keyManager;

    protected void authenticateInbound(MuleEvent event) throws SecurityException, UnauthorisedException, UnknownAuthenticationTypeException {
        Authentication authResult;
        PGPAuthentication authentication;
        MuleMessage message = event.getMessage();
        String userId = (String)this.getCredentialsAccessor().getCredentials(event);
        byte[] creds = null;
        try {
            creds = message.getPayloadAsBytes();
            creds = this.strategy.decrypt(creds, null);
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event.getMessage(), e1);
        }
        try {
            authentication = new PGPAuthentication(userId, this.decodeMsgRaw(creds));
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event.getMessage(), e1);
        }
        try {
            authResult = this.getSecurityManager().authenticate(authentication);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication request for user: " + userId + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(userId), event.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authResult);
        event.getSession().setSecurityContext(context);
        try {
            this.updatePayload(message, this.getUnencryptedMessageWithoutSignature((PGPAuthentication)authResult));
        }
        catch (Exception e2) {
            throw new UnauthorisedException(event.getMessage(), context, event.getEndpoint(), this);
        }
    }

    private Message decodeMsgRaw(byte[] raw) throws Exception {
        MessageFactory mf = MessageFactory.getInstance((String)"OpenPGP");
        ByteArrayInputStream in = new ByteArrayInputStream(raw);
        Collection msgs = mf.generateMessages((InputStream)in);
        return (Message)msgs.iterator().next();
    }

    private String getUnencryptedMessageWithoutSignature(PGPAuthentication auth) throws Exception {
        Message msg = (Message)auth.getCredentials();
        if (msg instanceof SignedMessage) {
            msg = ((SignedMessage)msg).getContents();
        }
        if (msg instanceof LiteralMessage) {
            return ((LiteralMessage)msg).getTextData();
        }
        throw new Exception("Wrong data");
    }

    protected void authenticateOutbound(MuleEvent event) throws SecurityException, UnauthorisedException {
        logger.debug((Object)("authenticateOutbound:" + event.getId()));
        if (!this.isAuthenticate()) {
            return;
        }
        MuleMessage message = event.getMessage();
        KeyBundle userKeyBundle = this.keyManager.getKeyBundle((String)this.getCredentialsAccessor().getCredentials(event));
        PGPCryptInfo cryptInfo = new PGPCryptInfo(userKeyBundle, this.signRequired);
        try {
            this.updatePayload(event.getMessage(), this.strategy.encrypt(message.getPayloadAsBytes(), cryptInfo));
        }
        catch (Exception e1) {
            throw new UnauthorisedException(CoreMessages.failedToReadPayload(), event.getMessage(), e1);
        }
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategyName != null) {
            this.strategy = this.endpoint.getMuleContext().getSecurityManager().getEncryptionStrategy(this.strategyName);
        }
        if (this.strategy == null) {
            throw new InitialisationException(PGPMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setStrategyName(String name) {
        this.strategyName = name;
    }

    public boolean isSignRequired() {
        return this.signRequired;
    }

    public void setSignRequired(boolean signRequired) {
        this.signRequired = signRequired;
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

