/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.ant.AntHelper;
import org.jbpm.db.JbpmSchema;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;

public class JbpmSchemaTask
extends Task {
    String jbpmCfg = null;
    String hibernateCfg = null;
    String hibernateProperties = null;
    boolean quiet = false;
    boolean text = false;
    String output = null;
    String delimiter = null;
    String actions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.actions == null) {
            this.actions = "create";
        }
        Configuration configuration = null;
        if (this.jbpmCfg == null && this.hibernateCfg == null) {
            InputStream defaultJbpmCfgStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jbpm.cfg.xml");
            if (defaultJbpmCfgStream != null) {
                this.jbpmCfg = "jbpm.cfg.xml";
                try {
                    defaultJbpmCfgStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                InputStream defaultHibernateCfgStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hibernate.cfg.xml");
                if (defaultHibernateCfgStream != null) {
                    this.hibernateCfg = "hibernate.cfg.xml";
                    try {
                        defaultHibernateCfgStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.jbpmCfg != null) {
            this.log("using jbpm configuration " + this.jbpmCfg);
            JbpmConfiguration jbpmConfiguration = AntHelper.getJbpmConfiguration(this.jbpmCfg);
            JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
            try {
                DbPersistenceServiceFactory dbPersistenceServiceFactory = (DbPersistenceServiceFactory)jbpmConfiguration.getServiceFactory("persistence");
                configuration = dbPersistenceServiceFactory.getConfiguration();
            }
            finally {
                jbpmContext.close();
            }
        } else if (this.hibernateCfg != null) {
            this.log("using hibernate configuration " + this.hibernateCfg);
            configuration = AntHelper.getConfiguration(this.hibernateCfg, this.hibernateProperties);
        } else {
            throw new BuildException("couldn't create schema.  no jbpm nor hibernate configuration specified.");
        }
        JbpmSchema jbpmSchema = new JbpmSchema(configuration);
        SchemaExport schemaExport = new SchemaExport(configuration);
        if (this.output != null) {
            schemaExport.setOutputFile(this.output);
        }
        if (this.delimiter != null) {
            schemaExport.setDelimiter(this.delimiter);
        }
        StringTokenizer tokenizer = new StringTokenizer(this.actions, ",");
        while (tokenizer.hasMoreTokens()) {
            String action = tokenizer.nextToken();
            if ("drop".equalsIgnoreCase(action)) {
                schemaExport.drop(!this.quiet, !this.text);
                continue;
            }
            if ("create".equalsIgnoreCase(action)) {
                schemaExport.create(!this.quiet, !this.text);
                continue;
            }
            if (!"clean".equalsIgnoreCase(action)) continue;
            jbpmSchema.cleanSchema();
        }
    }

    public void setActions(String actions) {
        this.actions = actions;
    }

    public void setJbpmCfg(String jbpmCfg) {
        this.jbpmCfg = jbpmCfg;
    }

    public void setHibernateCfg(String hibernateCfg) {
        this.hibernateCfg = hibernateCfg;
    }

    public void setHibernateProperties(String hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setText(boolean text) {
        this.text = text;
    }
}

