/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Iterator;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.RosterPacket;

public class RosterEntry {
    private String user;
    private String name;
    private RosterPacket.ItemType type;
    private RosterPacket.ItemStatus status;
    private XMPPConnection connection;

    RosterEntry(String user, String name, RosterPacket.ItemType type, RosterPacket.ItemStatus status, XMPPConnection connection) {
        this.user = user;
        this.name = name;
        this.type = type;
        this.status = status;
        this.connection = connection;
    }

    public String getUser() {
        return this.user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && name.equals(this.name)) {
            return;
        }
        this.name = name;
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.SET);
        packet.addRosterItem(RosterEntry.toRosterItem(this));
        this.connection.sendPacket(packet);
    }

    void updateState(String name, RosterPacket.ItemType type, RosterPacket.ItemStatus status) {
        this.name = name;
        this.type = type;
        this.status = status;
    }

    public Iterator getGroups() {
        ArrayList<RosterGroup> results = new ArrayList<RosterGroup>();
        Iterator i = this.connection.roster.getGroups();
        while (i.hasNext()) {
            RosterGroup group = (RosterGroup)i.next();
            if (!group.contains(this)) continue;
            results.add(group);
        }
        return results.iterator();
    }

    public RosterPacket.ItemType getType() {
        return this.type;
    }

    public RosterPacket.ItemStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null) {
            buf.append(this.name).append(": ");
        }
        buf.append(this.user);
        Iterator groups = this.getGroups();
        if (groups.hasNext()) {
            buf.append(" [");
            RosterGroup group = (RosterGroup)groups.next();
            buf.append(group.getName());
            while (groups.hasNext()) {
                buf.append(", ");
                group = (RosterGroup)groups.next();
                buf.append(group.getName());
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof RosterEntry) {
            return this.user.equals(((RosterEntry)object).getUser());
        }
        return false;
    }

    static RosterPacket.Item toRosterItem(RosterEntry entry) {
        RosterPacket.Item item = new RosterPacket.Item(entry.getUser(), entry.getName());
        item.setItemType(entry.getType());
        item.setItemStatus(entry.getStatus());
        Iterator j = entry.getGroups();
        while (j.hasNext()) {
            RosterGroup group = (RosterGroup)j.next();
            item.addGroupName(group.getName());
        }
        return item;
    }
}

