/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.AbstractWrappedMessage;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.transport.MessageAdapter;
import org.mule.transport.AbstractMessageAdapter;
import org.mule.transport.cxf.i18n.CxfMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = -1L;
    private Message payload;

    public CxfMessageAdapter(MessageAdapter msg) throws MuleException {
        super(msg);
    }

    public void setPayload(Message message) {
        this.payload = message;
    }

    public Object getPayload() {
        List objs = CastUtils.cast((List)((List)this.payload.getContent(List.class)));
        if (objs == null) {
            Object o = this.payload.getContent(Object.class);
            if (o != null) {
                return o;
            }
            return new Object[0];
        }
        if (objs.size() == 1 && objs.get(0) != null) {
            return objs.get(0);
        }
        return objs.toArray();
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        Collection<Attachment> attachments = this.getAttachments();
        AttachmentImpl newA = new AttachmentImpl(name);
        newA.setDataHandler(dataHandler);
        attachments.add((Attachment)newA);
    }

    public void removeAttachment(String name) throws Exception {
        Collection<Attachment> attachments = this.getAttachments();
        ArrayList<Attachment> newAttachments = new ArrayList<Attachment>();
        for (Attachment attachment : attachments) {
            if (attachment.getId() != null && attachment.getId().equals(name)) continue;
            newAttachments.add(attachment);
        }
        this.payload.setAttachments(newAttachments);
    }

    protected Collection<Attachment> getAttachments() throws MuleException {
        if (this.payload instanceof AbstractWrappedMessage) {
            AbstractWrappedMessage soap = (AbstractWrappedMessage)this.payload;
            return soap.getAttachments();
        }
        throw new DefaultMuleException(CxfMessages.inappropriateMessageTypeForAttachments(this.payload));
    }
}

