/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.BooleanUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.binding.soap.interceptor.SoapOutInterceptor;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.stax.StaxDataBinding;
import org.apache.cxf.databinding.stax.StaxDataBindingFeature;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.mule.api.MuleException;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.cxf.CxfConnector;
import org.mule.transport.cxf.MuleInvoker;
import org.mule.transport.cxf.i18n.CxfMessages;
import org.mule.transport.cxf.support.CopyAttachmentInInterceptor;
import org.mule.transport.cxf.support.CopyAttachmentOutInterceptor;
import org.mule.transport.cxf.support.CxfUtils;
import org.mule.transport.cxf.support.MuleHeadersInInterceptor;
import org.mule.transport.cxf.support.MuleProtocolHeadersOutInterceptor;
import org.mule.transport.cxf.support.OutputPayloadInterceptor;
import org.mule.transport.cxf.support.ProxyService;
import org.mule.transport.cxf.support.ProxyServiceFactoryBean;
import org.mule.transport.cxf.support.ResetStaxInterceptor;
import org.mule.transport.cxf.support.ReversibleStaxInInterceptor;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfMessageReceiver
extends AbstractMessageReceiver {
    protected CxfConnector connector;
    private Server server;
    private boolean proxy;
    private boolean applySecurityToProtocol;
    private boolean applyTransformersToProtocol;
    private boolean applyFiltersToProtocol;
    private boolean enableHeaders;
    private String payload;

    public CxfMessageReceiver(Connector connector, Service service, InboundEndpoint Endpoint2) throws CreateException {
        super(connector, service, Endpoint2);
        this.connector = (CxfConnector)connector;
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
        try {
            ServerFactoryBean sfb;
            Class<Object> targetCls;
            Map endpointProps = this.getEndpoint().getProperties();
            String wsdlUrl = (String)endpointProps.get("wsdlLocation");
            String bindingId = (String)endpointProps.get("bindingId");
            String frontend = (String)endpointProps.get("frontend");
            String serviceClassName = (String)endpointProps.get("serviceClass");
            String mtomEnabled = (String)endpointProps.get("mtomEnabled");
            List databinding = (List)endpointProps.get("databinding");
            List features = (List)endpointProps.get("features");
            String proxyStr = (String)endpointProps.get("proxy");
            this.payload = (String)endpointProps.get("payload");
            this.applyFiltersToProtocol = this.isTrue((String)endpointProps.get("applyFiltersToProtocol"), true);
            this.applySecurityToProtocol = this.isTrue((String)endpointProps.get("applySecurityToProtocol"), true);
            this.applyTransformersToProtocol = this.isTrue((String)endpointProps.get("applyTransformersToProtocol"), true);
            this.enableHeaders = this.isTrue((String)endpointProps.get("enableMuleSoapHeaders"), true);
            Class svcCls = null;
            this.proxy = BooleanUtils.toBoolean((String)proxyStr);
            if (this.proxy) {
                targetCls = svcCls = ProxyService.class;
                frontend = "simple";
            } else {
                if (StringUtils.isEmpty((String)frontend)) {
                    frontend = this.connector.getDefaultFrontend();
                }
                if (!StringUtils.isEmpty((String)serviceClassName)) {
                    svcCls = ClassUtils.loadClass((String)serviceClassName, ((Object)((Object)this)).getClass());
                }
                targetCls = this.getTargetClass(svcCls);
                if (svcCls == null) {
                    svcCls = targetCls;
                }
            }
            if ("simple".equals(frontend)) {
                sfb = new ServerFactoryBean();
                sfb.setDataBinding((DataBinding)new AegisDatabinding());
            } else if ("jaxws".equals(frontend)) {
                sfb = new JaxWsServerFactoryBean();
            } else {
                throw new CreateException(CxfMessages.invalidFrontend(frontend), (Object)this);
            }
            if (!this.proxy) {
                if (databinding != null && databinding.size() > 0) {
                    sfb.setDataBinding((DataBinding)databinding.get(0));
                }
                if (this.service.getComponent() instanceof JavaComponent) {
                    sfb.setServiceBean(((JavaComponent)this.service.getComponent()).getObjectFactory().getInstance());
                }
            } else {
                sfb.setDataBinding((DataBinding)new StaxDataBinding());
                sfb.getFeatures().add(new StaxDataBindingFeature());
                sfb.setServiceFactory((ReflectionServiceFactoryBean)new ProxyServiceFactoryBean());
            }
            if (bindingId != null) {
                sfb.setBindingId(bindingId);
            }
            if (features != null) {
                sfb.getFeatures().addAll(features);
            }
            if (mtomEnabled != null) {
                HashMap<String, String> properties = sfb.getProperties();
                if (properties == null) {
                    properties = new HashMap<String, String>();
                    sfb.setProperties(properties);
                }
                properties.put("mtom-enabled", mtomEnabled);
                properties.put("write.attachments", (String)((Object)Boolean.valueOf(true)));
            }
            sfb.setInInterceptors((List)endpointProps.get("inInterceptors"));
            sfb.setInFaultInterceptors((List)endpointProps.get("inFaultInterceptors"));
            sfb.setOutInterceptors((List)endpointProps.get("outInterceptors"));
            sfb.setOutFaultInterceptors((List)endpointProps.get("outFaultInterceptors"));
            if (sfb.getInInterceptors() == null) {
                sfb.setInInterceptors(new ArrayList());
            }
            sfb.getInInterceptors().add(new MuleHeadersInInterceptor());
            if (sfb.getOutInterceptors() == null) {
                sfb.setOutInterceptors(new ArrayList());
            }
            if (sfb.getOutFaultInterceptors() == null) {
                sfb.setOutFaultInterceptors(new ArrayList());
            }
            if (this.enableHeaders) {
                sfb.getOutInterceptors().add(new MuleProtocolHeadersOutInterceptor());
                sfb.getOutFaultInterceptors().add(new MuleProtocolHeadersOutInterceptor());
            }
            if (this.proxy) {
                sfb.getOutInterceptors().add(new OutputPayloadInterceptor());
                sfb.getInInterceptors().add(new CopyAttachmentInInterceptor());
                sfb.getOutInterceptors().add(new CopyAttachmentOutInterceptor());
                if (this.isProxyEnvelope()) {
                    sfb.getInInterceptors().add(new ReversibleStaxInInterceptor());
                    sfb.getInInterceptors().add(new ResetStaxInterceptor());
                }
            }
            sfb.setServiceClass(svcCls);
            sfb.setAddress(this.getAddressWithoutQuery());
            if (wsdlUrl != null) {
                sfb.setWsdlURL(wsdlUrl);
            }
            ReflectionServiceFactoryBean svcFac = sfb.getServiceFactory();
            this.addIgnoredMethods(svcFac, Callable.class.getName());
            this.addIgnoredMethods(svcFac, Initialisable.class.getName());
            this.addIgnoredMethods(svcFac, Disposable.class.getName());
            this.addIgnoredMethods(svcFac, ServiceAware.class.getName());
            String name = (String)endpointProps.get("serviceName");
            String namespace = (String)endpointProps.get("namespace");
            this.initServiceName(svcCls, name, namespace, svcFac);
            boolean sync = this.endpoint.isSynchronous();
            if (this.endpoint.getEndpointURI().getScheme().startsWith("http") || this.endpoint.getEndpointURI().getScheme().startsWith("servlet")) {
                sync = true;
            }
            sfb.setInvoker((Invoker)new MuleInvoker(this, targetCls, sync));
            sfb.setStart(false);
            Bus bus = this.connector.getCxfBus();
            sfb.setBus(bus);
            sfb.getServiceFactory().setBus(bus);
            this.initializeServerFactory(sfb);
            Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
            if (null != configurer) {
                configurer.configureBean(sfb.getServiceFactory().getEndpointName().toString(), (Object)sfb);
            }
            this.server = sfb.create();
            if (this.proxy && this.isProxyEnvelope()) {
                CxfUtils.removeInterceptor(this.server.getEndpoint().getBinding().getOutInterceptors(), SoapOutInterceptor.class.getName());
            }
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private boolean isTrue(String string, boolean defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        return BooleanUtils.toBoolean((String)string);
    }

    protected void initializeServerFactory(ServerFactoryBean sfb) {
    }

    private String getAddressWithoutQuery() {
        String a = this.getEndpointURI().getAddress();
        int idx = a.lastIndexOf(63);
        if (idx > -1) {
            a = a.substring(0, idx);
        }
        return a;
    }

    private void initServiceName(Class<?> exposedInterface, String name, String namespace, ReflectionServiceFactoryBean svcFac) {
        svcFac.setServiceClass(exposedInterface);
        for (AbstractServiceConfiguration c : svcFac.getServiceConfigurations()) {
            c.setServiceFactory(svcFac);
        }
        if (name != null && namespace == null) {
            namespace = svcFac.getServiceQName().getNamespaceURI();
        } else if (name == null && namespace != null) {
            name = svcFac.getServiceQName().getLocalPart();
        }
        if (name != null) {
            svcFac.setServiceName(new QName(namespace, name));
        }
    }

    public void addIgnoredMethods(ReflectionServiceFactoryBean svcFac, String className) {
        try {
            Class c = ClassUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
            for (int i = 0; i < c.getMethods().length; ++i) {
                svcFac.getIgnoredMethods().add(c.getMethods()[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private Class<?> getTargetClass(Class<?> svcCls) throws MuleException, ClassNotFoundException {
        Component component = this.service.getComponent();
        if (!(component instanceof JavaComponent)) {
            if (svcCls == null) {
                throw new InitialisationException(CxfMessages.serviceClassRequiredWithPassThrough(), (Initialisable)this);
            }
            return svcCls;
        }
        try {
            return ((JavaComponent)component).getObjectType();
        }
        catch (Exception e) {
            throw new CreateException((Throwable)e, (Object)this);
        }
    }

    public void doConnect() throws Exception {
        super.doConnect();
        this.server.start();
        this.connector.registerReceiverWithMuleService((MessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doDisconnect() throws Exception {
        super.doDisconnect();
        this.server.stop();
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public boolean isApplySecurityToProtocol() {
        return this.applySecurityToProtocol;
    }

    public boolean isApplyTransformersToProtocol() {
        return this.applyTransformersToProtocol;
    }

    public boolean isApplyFiltersToProtocol() {
        return this.applyFiltersToProtocol;
    }

    public boolean isProxyEnvelope() {
        return "envelope".equals(this.payload);
    }
}

