/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.cxf;

import java.util.Iterator;
import java.util.Properties;
import org.apache.cxf.endpoint.ClientImpl;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.cxf.ClientWrapper;
import org.mule.transport.cxf.CxfConnector;

public class CxfMessageRequester
extends AbstractMessageRequester {
    protected CxfConnector connector;
    private ClientWrapper wrapper;

    public CxfMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (CxfConnector)endpoint.getConnector();
    }

    protected void doConnect() throws Exception {
        this.wrapper = new ClientWrapper(this.connector.getCxfBus(), this.endpoint);
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        ((ClientImpl)this.wrapper.getClient()).setSynchronousTimeout((int)timeout);
        String method = (String)this.endpoint.getProperty((Object)"method");
        if (method == null) {
            method = (String)this.endpoint.getProperty((Object)"operation");
        }
        Properties params = this.endpoint.getEndpointURI().getUserParams();
        Object[] args = new Object[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next().toString();
            ++i;
        }
        Object[] response = this.wrapper.getClient().invoke(method, args);
        if (response != null && response.length == 1) {
            return new DefaultMuleMessage(response[0], this.connector.getMuleContext());
        }
        return new DefaultMuleMessage((Object)response, this.connector.getMuleContext());
    }
}

