/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file.transformers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.simple.ObjectToByteArray;
import org.mule.util.ArrayUtils;

public class FileToByteArray
extends ObjectToByteArray {
    public FileToByteArray() {
        this.registerSourceType(File.class);
        this.registerSourceType(byte[].class);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doTransform(Object src, String encoding) throws TransformerException {
        byte[] byArray;
        if (src instanceof byte[]) {
            return src;
        }
        if (src instanceof InputStream || src instanceof String) {
            return super.doTransform(src, encoding);
        }
        File file = (File)src;
        if (file == null) {
            throw new TransformerException(this, (Throwable)new IllegalArgumentException("null file"));
        }
        if (!file.exists()) {
            throw new TransformerException(this, (Throwable)new FileNotFoundException(file.getPath()));
        }
        if (file.length() == 0L) {
            this.logger.warn((Object)("File is empty: " + file.getAbsolutePath()));
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        FileInputStream fis = null;
        byte[] bytes = null;
        try {
            fis = new FileInputStream(file);
            int length = new Long(file.length()).intValue();
            bytes = new byte[length];
            fis.read(bytes);
            byArray = bytes;
        }
        catch (OutOfMemoryError oom) {
            try {
                throw new TransformerException(this, (Throwable)oom);
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return byArray;
    }
}

