/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.servlet.MuleReceiverServlet;

public class MuleRESTReceiverServlet
extends MuleReceiverServlet {
    private static final long serialVersionUID = -2395763805839859649L;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            InboundEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            if (endpoint != null) {
                String timeoutString = httpServletRequest.getParameter("timeout");
                long to = this.timeout;
                if (timeoutString != null) {
                    to = Long.parseLong(timeoutString);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
                }
                MuleMessage returnMessage = endpoint.request(to);
                this.writeResponse(httpServletResponse, returnMessage);
            } else {
                MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
                httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
                DefaultMuleMessage message = new DefaultMuleMessage(receiver.getEndpoint().getConnector().getMessageAdapter(httpServletRequest), this.muleContext);
                MuleMessage returnMessage = receiver.routeMessage((MuleMessage)message, true);
                this.writeResponse(httpServletResponse, returnMessage);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to route event through Servlet Receiver", httpServletResponse);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            DefaultMuleMessage message = new DefaultMuleMessage(receiver.getEndpoint().getConnector().getMessageAdapter(httpServletRequest), this.muleContext);
            MuleMessage returnMessage = receiver.routeMessage((MuleMessage)message, true);
            this.writeResponse(httpServletResponse, returnMessage);
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule", httpServletResponse);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MessageReceiver receiver = this.getReceiverForURI(httpServletRequest);
            httpServletRequest.setAttribute("org.mule.servlet.payload.param", (Object)this.payloadParameterName);
            DefaultMuleMessage message = new DefaultMuleMessage(receiver.getEndpoint().getConnector().getMessageAdapter(httpServletRequest), this.muleContext);
            receiver.routeMessage((MuleMessage)message, this.muleContext.getConfiguration().isDefaultSynchronousEndpoints());
            httpServletResponse.setStatus(201);
            if (this.feedback) {
                httpServletResponse.getWriter().write("Item was created at endpointUri: " + receiver.getEndpointURI());
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Post event to Mule" + e.getMessage(), httpServletResponse);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            MuleMessage returnMessage;
            InboundEndpoint endpoint = this.getEndpointForURI(httpServletRequest);
            String timeoutString = httpServletRequest.getParameter("timeout");
            long to = this.timeout;
            if (timeoutString != null) {
                to = new Long(timeoutString);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Making request using endpoint: " + endpoint.toString() + " timeout is: " + to));
            }
            if ((returnMessage = endpoint.request(to)) != null) {
                httpServletResponse.setStatus(200);
            } else {
                httpServletResponse.setStatus(204);
            }
        }
        catch (Exception e) {
            this.handleException(e, "Failed to Delete mule event via receive using uri: " + httpServletRequest.getPathInfo(), httpServletResponse);
        }
    }

    protected InboundEndpoint getEndpointForURI(HttpServletRequest httpServletRequest) throws MuleException {
        MessageReceiver receiver;
        InboundEndpoint endpoint;
        String uri;
        int i;
        String endpointName = httpServletRequest.getParameter("endpoint");
        if (endpointName == null && (i = (uri = httpServletRequest.getPathInfo()).lastIndexOf("/")) > -1) {
            endpointName = uri.substring(i + 1);
        }
        if ((endpoint = this.muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(endpointName)) == null && (receiver = (MessageReceiver)this.getReceivers().get(endpointName)) != null) {
            endpoint = receiver.getEndpoint();
        }
        return endpoint;
    }
}

