/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.ArrayList;
import java.util.Properties;
import javax.resource.spi.work.WorkListener;
import org.mule.DefaultMuleContext;
import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.config.ConfigurationException;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.context.MuleContextBuilder;
import org.mule.api.context.WorkManager;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.model.Model;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.AbstractConfigurationBuilder;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.model.seda.SedaModel;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Banana;

public class DefaultMuleContextFactoryTestCase
extends AbstractMuleTestCase {
    private DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
    private static String TEST_STRING_KEY = "test";
    private static String TEST_STRING_VALUE = "test_value";
    private static String TEST_STRING_KEY2 = "test2";
    private static String TEST_STRING_VALUE2 = "test_value2";
    private static String TEST_OBJECT_NAME = "testObject";
    private static String TEST_MODEL_NAME = "testModel";

    public void testCreateMuleContext() throws InitialisationException, ConfigurationException {
        MuleContext muleContext = this.muleContextFactory.createMuleContext();
        this.testMuleContext(muleContext);
        this.testDefaults(muleContext);
    }

    public void testCreateMuleContextConfigurationBuilder() throws InitialisationException, ConfigurationException {
        MuleContext muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new TestConfigurationBuilder());
        this.testMuleContext(muleContext);
        this.testConfigurationBuilder1Objects(muleContext);
        this.testNoDefaults(muleContext);
    }

    public void testCreateMuleContextListMuleContextBuilder() throws InitialisationException, ConfigurationException {
        ArrayList<AbstractConfigurationBuilder> configBuilders = new ArrayList<AbstractConfigurationBuilder>();
        configBuilders.add(new TestConfigurationBuilder());
        configBuilders.add(new TestConfigurationBuilder2());
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        MuleContext muleContext = this.muleContextFactory.createMuleContext(configBuilders, (MuleContextBuilder)muleContextBuilder);
        this.testCustomMuleContext(muleContext);
        this.testConfigurationBuilder1Objects(muleContext);
        this.testConfigurationBuilder2Objects(muleContext);
        this.testNoDefaults(muleContext);
    }

    public void testCreateMuleContextMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        MuleContext muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new SimpleConfigurationBuilder(null), (MuleContextBuilder)muleContextBuilder);
        this.testCustomMuleContext(muleContext);
        this.testNoDefaults(muleContext);
    }

    public void testCreateMuleContextConfigurationBuilderMuleContextBuilder() throws InitialisationException, ConfigurationException {
        TestMuleContextBuilder muleContextBuilder = new TestMuleContextBuilder();
        MuleContext muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new TestConfigurationBuilder2(), (MuleContextBuilder)muleContextBuilder);
        this.testCustomMuleContext(muleContext);
        this.testConfigurationBuilder2Objects(muleContext);
        this.testNoDefaults(muleContext);
    }

    public void testCreateMuleContextString() throws InitialisationException, ConfigurationException {
        MuleContext muleContext = null;
        try {
            muleContext = this.muleContextFactory.createMuleContext("log4j.properties");
        }
        catch (ConfigurationException e) {
            DefaultMuleContextFactoryTestCase.assertEquals((String)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j.properties'}]\" found.  Check you have configuration module on your classpath and are using correct file extension. (org.mule.api.config.ConfigurationException)", (String)e.getMessage());
        }
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext);
    }

    public void testCreateMuleContextStringProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey1", "testValue1");
        properties.put("testKey2", "testValue2");
        MuleContext muleContext = null;
        try {
            muleContext = this.muleContextFactory.createMuleContext("log4j.properties", properties);
        }
        catch (ConfigurationException e) {
            DefaultMuleContextFactoryTestCase.assertEquals((String)"No suitable configuration builder for resource \"[ConfigResource{resourceName='log4j.properties'}]\" found.  Check you have configuration module on your classpath and are using correct file extension. (org.mule.api.config.ConfigurationException)", (String)e.getMessage());
        }
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext);
    }

    public void testCreateMuleContextConfigurationBuilderProperties() throws InitialisationException, ConfigurationException {
        Properties properties = new Properties();
        properties.put("testKey3", "testValue3");
        properties.put("testKey4", "testValue4");
        MuleContext muleContext = this.muleContextFactory.createMuleContext((ConfigurationBuilder)new TestConfigurationBuilder(), properties);
        this.testMuleContext(muleContext);
        this.testConfigurationBuilder1Objects(muleContext);
        DefaultMuleContextFactoryTestCase.assertEquals((Object)"testValue3", (Object)muleContext.getRegistry().lookupObject("testKey3"));
        DefaultMuleContextFactoryTestCase.assertEquals((Object)"testValue4", (Object)muleContext.getRegistry().lookupObject("testKey4"));
        this.testNoDefaults(muleContext);
    }

    private void testDefaults(MuleContext muleContext) {
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("_muleQueueManager"));
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("_muleSecurityManager"));
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("_muleSystemModel"));
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("_muleEndpointFactory"));
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("_muleSimpleRegistryBootstrap"));
    }

    private void testNoDefaults(MuleContext muleContext) {
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext.getRegistry().lookupObject("_muleQueueManager"));
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext.getRegistry().lookupObject("_muleSecurityManager"));
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext.getRegistry().lookupObject("_muleSystemModel"));
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext.getRegistry().lookupObject("_muleEndpointFactory"));
        DefaultMuleContextFactoryTestCase.assertNull((Object)muleContext.getRegistry().lookupObject("_muleSimpleRegistryBootstrap"));
    }

    private void testMuleContext(MuleContext muleContext) {
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext);
        DefaultMuleContextFactoryTestCase.assertEquals(DefaultMuleContext.class, muleContext.getClass());
        DefaultMuleContextFactoryTestCase.assertTrue((boolean)muleContext.isInitialised());
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getConfiguration());
        DefaultMuleContextFactoryTestCase.assertEquals(DefaultMuleConfiguration.class, muleContext.getConfiguration().getClass());
        DefaultMuleContextFactoryTestCase.assertNotNull(muleContext.getLifecycleManager().getClass());
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[0]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[1]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[2]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[3]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getNotificationManager());
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getWorkManager());
    }

    private void testCustomMuleContext(MuleContext muleContext) {
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext);
        DefaultMuleContextFactoryTestCase.assertEquals(TestMuleContext.class, muleContext.getClass());
        DefaultMuleContextFactoryTestCase.assertTrue((boolean)muleContext.isInitialised());
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getConfiguration());
        DefaultMuleContextFactoryTestCase.assertNotNull(muleContext.getLifecycleManager().getClass());
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[0]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[1]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[2]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getLifecycleManager().getLifecycles().toArray()[3]);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getNotificationManager());
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getWorkManager());
    }

    private void testConfigurationBuilder1Objects(MuleContext muleContext) {
        DefaultMuleContextFactoryTestCase.assertEquals((Object)TEST_STRING_VALUE, (Object)muleContext.getRegistry().lookupObject(TEST_STRING_KEY));
        Object obj = muleContext.getRegistry().lookupObject(TEST_OBJECT_NAME);
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)obj);
        DefaultMuleContextFactoryTestCase.assertEquals(Banana.class, obj.getClass());
    }

    private void testConfigurationBuilder2Objects(MuleContext muleContext) {
        DefaultMuleContextFactoryTestCase.assertEquals((Object)TEST_STRING_VALUE2, (Object)muleContext.getRegistry().lookupObject(TEST_STRING_KEY2));
        DefaultMuleContextFactoryTestCase.assertNotNull((Object)muleContext.getRegistry().lookupModel(TEST_MODEL_NAME));
        DefaultMuleContextFactoryTestCase.assertEquals((String)TEST_MODEL_NAME, (String)muleContext.getRegistry().lookupModel(TEST_MODEL_NAME).getName());
    }

    protected MuleContext createMuleContext() throws Exception {
        return null;
    }

    static class TestMuleConfiguration
    extends DefaultMuleConfiguration {
        TestMuleConfiguration() {
        }
    }

    static class TestMuleContext
    extends DefaultMuleContext {
        public TestMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, LifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
            super(config, workManager, workListener, lifecycleManager, notificationManager);
        }
    }

    static class TestMuleContextBuilder
    extends DefaultMuleContextBuilder {
        TestMuleContextBuilder() {
        }

        public MuleContext buildMuleContext() {
            TestMuleContext muleContext = new TestMuleContext(this.getMuleConfiguration(), this.getWorkManager(), this.getWorkListener(), this.getLifecycleManager(), this.getNotificationManager());
            return muleContext;
        }
    }

    static class TestConfigurationBuilder2
    extends AbstractConfigurationBuilder {
        TestConfigurationBuilder2() {
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
            muleContext.getRegistry().registerObject(TEST_STRING_KEY2, (Object)TEST_STRING_VALUE2);
            SedaModel testModel = new SedaModel();
            testModel.setName(TEST_MODEL_NAME);
            muleContext.getRegistry().registerModel((Model)testModel);
        }
    }

    static class TestConfigurationBuilder
    extends AbstractConfigurationBuilder {
        TestConfigurationBuilder() {
        }

        protected void doConfigure(MuleContext muleContext) throws Exception {
            muleContext.getRegistry().registerObject(TEST_STRING_KEY, (Object)TEST_STRING_VALUE);
            muleContext.getRegistry().registerObject(TEST_OBJECT_NAME, (Object)new Banana());
        }
    }
}

