/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.seda;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.FullConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.lifecycle.Callable;
import org.mule.api.model.Model;
import org.mule.api.object.ObjectFactory;
import org.mule.api.registry.RegistrationException;
import org.mule.api.service.Service;
import org.mule.component.DefaultJavaComponent;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.config.ChainedThreadingProfile;
import org.mule.config.QueueProfile;
import org.mule.model.seda.SedaModel;
import org.mule.model.seda.SedaService;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueManager;

public class SedaServiceTestCase
extends AbstractMuleTestCase {
    public void testQueueConfiguration() throws Exception {
        boolean persistent = true;
        int capacity = 345;
        String queueName = "test.service";
        QueueManager queueManager = muleContext.getQueueManager();
        Mock mockTransactionalQueueManager = new Mock(QueueManager.class);
        mockTransactionalQueueManager.expect("toString");
        mockTransactionalQueueManager.expect("toString");
        mockTransactionalQueueManager.expect("setQueueConfiguration", (ConstraintMatcher)new FullConstraintMatcher(C.eq((Object)queueName), C.eq((Object)new QueueConfiguration(capacity, persistent))));
        mockTransactionalQueueManager.expectAndReturn("getQueueSession", (Object)queueManager.getQueueSession());
        muleContext.getRegistry().registerObject("_muleQueueManager", mockTransactionalQueueManager.proxy());
        SedaService service = new SedaService();
        service.setMuleContext(muleContext);
        service.setName("test");
        SedaModel model = new SedaModel();
        model.setMuleContext(muleContext);
        model.initialise();
        service.setModel((Model)model);
        service.setQueueProfile(new QueueProfile(capacity, persistent));
        try {
            muleContext.getRegistry().registerService((Service)service);
        }
        catch (RegistrationException e) {
            if (e.getCause().getCause().getCause() instanceof AssertionFailedError) {
                SedaServiceTestCase.fail((String)"Queue configuration does not match service queue profile");
            }
            throw e;
        }
        SedaServiceTestCase.assertEquals((String)queueName, (String)service.queue.getName());
    }

    public void testSedaModelEventTimeoutDefault() throws Exception {
        SedaService service = new SedaService();
        service.setName("test");
        service.setComponent((Component)new DefaultJavaComponent((ObjectFactory)new PrototypeObjectFactory(Object.class)));
        service.setModel((Model)new SedaModel());
        service.setMuleContext(muleContext);
        service.getModel().setMuleContext(muleContext);
        service.getModel().initialise();
        service.initialise();
        SedaServiceTestCase.assertNotNull((Object)service.getQueueTimeout());
        SedaServiceTestCase.assertTrue((service.getQueueTimeout() != 0 ? 1 : 0) != 0);
    }

    public void testSpiWorkThrowableHandling() throws Exception {
        try {
            SedaService service = new SedaService();
            service.setName("test");
            service.setComponent((Component)new DefaultJavaComponent((ObjectFactory)new PrototypeObjectFactory(Object.class)));
            service.setModel((Model)new SedaModel());
            service.handleWorkException(this.getTestWorkEvent(), "workRejected");
        }
        catch (MuleRuntimeException mrex) {
            SedaServiceTestCase.assertNotNull((Object)((Object)mrex));
            SedaServiceTestCase.assertTrue((mrex.getCause().getClass() == Throwable.class ? 1 : 0) != 0);
            SedaServiceTestCase.assertEquals((String)"testThrowable", (String)mrex.getCause().getMessage());
        }
    }

    public void testDispatchToPausedService() throws Exception {
        Service service = SedaServiceTestCase.getTestService();
        service.setMuleContext(muleContext);
        service.start();
        service.pause();
        service.dispatchEvent(SedaServiceTestCase.getTestInboundEvent("test"));
    }

    public void testMaxActiveThreadsEqualsOneWhenExhaustedActionWait() throws Exception {
        final Latch latch = new Latch();
        SedaService service = new SedaService();
        service.setName("testMaxActiveThreadsEqualsOne");
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        ChainedThreadingProfile threadingProfile = (ChainedThreadingProfile)muleContext.getDefaultServiceThreadingProfile();
        threadingProfile.setMaxThreadsActive(1);
        threadingProfile.setThreadWaitTimeout(200L);
        threadingProfile.setPoolExhaustedAction(0);
        service.setThreadingProfile((ThreadingProfile)threadingProfile);
        service.setComponent((Component)new SimpleCallableJavaComponent(new Callable(){

            public Object onCall(MuleEventContext eventContext) throws Exception {
                latch.countDown();
                return null;
            }
        }));
        muleContext.getRegistry().registerService((Service)service);
        service.start();
        service.dispatchEvent(SedaServiceTestCase.getTestInboundEvent("test"));
        SedaServiceTestCase.assertTrue((boolean)latch.await(200L, TimeUnit.MILLISECONDS));
    }

    public void testDoThreadingFalse() throws Exception {
        final Latch latch = new Latch();
        String serviceName = "testDoThreadingFalse";
        String serviceThreadName = "testDoThreadingFalse.1";
        SedaService service = new SedaService();
        service.setName("testDoThreadingFalse");
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        ChainedThreadingProfile threadingProfile = (ChainedThreadingProfile)muleContext.getDefaultServiceThreadingProfile();
        threadingProfile.setDoThreading(false);
        service.setThreadingProfile((ThreadingProfile)threadingProfile);
        service.setComponent((Component)new SimpleCallableJavaComponent(new Callable(){

            public Object onCall(MuleEventContext eventContext) throws Exception {
                Assert.assertEquals((String)"testDoThreadingFalse.1", (String)Thread.currentThread().getName());
                latch.countDown();
                return null;
            }
        }));
        muleContext.getRegistry().registerService((Service)service);
        service.start();
        service.dispatchEvent(SedaServiceTestCase.getTestInboundEvent("test"));
        SedaServiceTestCase.assertTrue((boolean)latch.await(200L, TimeUnit.MILLISECONDS));
    }

    public void testDoThreadingTrue() throws Exception {
        final Latch latch = new Latch();
        String serviceName = "testDoThreadingFalse";
        String serviceThreadName = "testDoThreadingFalse.1";
        SedaService service = new SedaService();
        service.setName("testDoThreadingFalse");
        service.setModel(muleContext.getRegistry().lookupSystemModel());
        ChainedThreadingProfile threadingProfile = (ChainedThreadingProfile)muleContext.getDefaultServiceThreadingProfile();
        threadingProfile.setDoThreading(true);
        service.setThreadingProfile((ThreadingProfile)threadingProfile);
        service.setComponent((Component)new SimpleCallableJavaComponent(new Callable(){

            public Object onCall(MuleEventContext eventContext) throws Exception {
                Assert.assertFalse((boolean)"testDoThreadingFalse.1".equals(Thread.currentThread().getName()));
                latch.countDown();
                return null;
            }
        }));
        muleContext.getRegistry().registerService((Service)service);
        service.start();
        service.dispatchEvent(SedaServiceTestCase.getTestInboundEvent("test"));
        SedaServiceTestCase.assertTrue((boolean)latch.await(200L, TimeUnit.MILLISECONDS));
    }

    private WorkEvent getTestWorkEvent() {
        return new WorkEvent((Object)this, 2, this.getTestWork(), new WorkException(new Throwable("testThrowable")));
    }

    private Work getTestWork() {
        return new Work(){

            public void release() {
            }

            public void run() {
            }
        };
    }
}

