/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.ReflectionEntryPointResolver;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Fruit;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitLover;
import org.mule.tck.testmodels.fruit.Kiwi;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.WaterMelon;
import org.mule.transport.NullPayload;

public class ReflectionEntryPointResolverTestCase
extends AbstractMuleTestCase {
    public void testExplicitMethodMatch() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new WaterMelon(), ReflectionEntryPointResolverTestCase.getTestEventContext("blah"));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }

    public void testExplicitMethodMatchComplexObject() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new FruitLover("Mmmm")));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }

    public void testMethodMatchWithArguments() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Object[]{new Apple(), new Banana()}));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(result.getResult() instanceof Fruit[]));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[0] instanceof Apple));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[1] instanceof Banana));
        ReflectionEntryPointResolverTestCase.assertEquals((String)"addAppleAndBanana", (String)result.getMethodCalled());
        result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Object[]{new Banana(), new Apple()}));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(result.getResult() instanceof Fruit[]));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[0] instanceof Banana));
        ReflectionEntryPointResolverTestCase.assertTrue((boolean)(((Fruit[])result.getResult())[1] instanceof Apple));
        ReflectionEntryPointResolverTestCase.assertEquals((String)"addBananaAndApple", (String)result.getMethodCalled());
    }

    public void testExplicitMethodMatchSetArrayFail() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Fruit[]{new Apple(), new Orange()}));
        ReflectionEntryPointResolverTestCase.assertEquals((String)"Test should have failed because the arguments were not wrapped properly: ", (int)result.getState(), (int)2);
    }

    public void testExplicitMethodMatchSetArrayPass() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new FruitBowl(), ReflectionEntryPointResolverTestCase.getTestEventContext(new Object[]{new Fruit[]{new Apple(), new Orange()}}));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }

    public void testFailEntryPointMultiplePayloadMatches() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        RequestContext.setEvent((MuleEvent)ReflectionEntryPointResolverTestCase.getTestEvent("Hello"));
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), RequestContext.getEventContext());
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)2);
    }

    public void testMatchOnNoArgs() throws Exception {
        ReflectionEntryPointResolver resolver = new ReflectionEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new Kiwi(), ReflectionEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance()));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)2);
        resolver.setAcceptVoidMethods(true);
        result = resolver.invoke((Object)new Kiwi(), ReflectionEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance()));
        ReflectionEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
        ReflectionEntryPointResolverTestCase.assertEquals((String)"bite", (String)result.getMethodCalled());
    }
}

