/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.HashMap;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.Router;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.ServiceRoutingException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.MessageDispatcher;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.routing.ForwardingCatchAllStrategy;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.transformer.AbstractTransformer;
import org.mule.util.CollectionUtils;

public class CatchAllStrategiesTestCase
extends AbstractMuleTestCase {
    public void testLoggingOnlyStrategy() throws Exception {
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        LoggingCatchAllStrategy strategy = new LoggingCatchAllStrategy();
        strategy.catchMessage(event.getMessage(), null);
    }

    public void testForwardingStrategy() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        Mock endpoint = MuleTestUtils.getMockOutboundEndpoint();
        Mock dispatcher = new Mock(MessageDispatcher.class);
        Mock connector = MuleTestUtils.getMockConnector();
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        strategy.setEndpoint((OutboundEndpoint)endpoint.proxy());
        endpoint.expectAndReturn("isSynchronous", false);
        endpoint.expectAndReturn("isSynchronous", false);
        endpoint.expectAndReturn("getProperties", new HashMap());
        endpoint.expectAndReturn("getProperties", new HashMap());
        endpoint.expectAndReturn("getEndpointURI", (Object)new MuleEndpointURI("test://dummy", muleContext));
        endpoint.expectAndReturn("getEndpointURI", (Object)new MuleEndpointURI("test://dummy", muleContext));
        endpoint.expect("dispatch", (Object)C.isA(DefaultMuleEvent.class));
        strategy.catchMessage(event.getMessage(), null);
        endpoint.verify();
        dispatcher.verify();
        connector.verify();
        CatchAllStrategiesTestCase.assertNotNull((Object)strategy.getEndpoint());
    }

    public void testForwardingStrategyNullEndpoint() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        strategy.setEndpoint(null);
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        MuleSession session = CatchAllStrategiesTestCase.getTestSession(CatchAllStrategiesTestCase.getTestService(), muleContext);
        try {
            strategy.catchMessage(event.getMessage(), session);
            CatchAllStrategiesTestCase.fail();
        }
        catch (ServiceRoutingException sre) {
            // empty catch block
        }
    }

    public void testForwardingStrategyWithTransform() throws Exception {
        ForwardingCatchAllStrategy strategy = new ForwardingCatchAllStrategy();
        strategy.setSendTransformed(true);
        Mock endpoint = MuleTestUtils.getMockOutboundEndpoint();
        Mock dispatcher = new Mock(MessageDispatcher.class);
        Mock connector = MuleTestUtils.getMockConnector();
        MuleEvent event = CatchAllStrategiesTestCase.getTestEvent("UncaughtEvent");
        strategy.setEndpoint((OutboundEndpoint)endpoint.proxy());
        endpoint.expectAndReturn("isSynchronous", true);
        endpoint.expectAndReturn("isSynchronous", true);
        endpoint.expectAndReturn("getTransformers", (Object)CollectionUtils.singletonList((Object)((Object)new TestEventTransformer())));
        endpoint.expectAndReturn("getTransformers", (Object)CollectionUtils.singletonList((Object)((Object)new TestEventTransformer())));
        endpoint.expectAndReturn("getProperties", new HashMap());
        endpoint.expectAndReturn("getProperties", new HashMap());
        endpoint.expectAndReturn("getEndpointURI", (Object)new MuleEndpointURI("test://dummy", muleContext));
        endpoint.expectAndReturn("getEndpointURI", (Object)new MuleEndpointURI("test://dummy", muleContext));
        endpoint.expect("send", (Object)new Constraint(){

            public boolean eval(Object arg0) {
                if (arg0 instanceof MuleEvent) {
                    return "Transformed Test Data".equals(((MuleEvent)arg0).getMessage().getPayload());
                }
                return false;
            }
        });
        strategy.catchMessage(event.getMessage(), null);
        endpoint.verify();
        dispatcher.verify();
        connector.verify();
        CatchAllStrategiesTestCase.assertNotNull((Object)strategy.getEndpoint());
    }

    public void testFullRouter() throws Exception {
        final int[] count1 = new int[]{0};
        final int[] count2 = new int[]{0};
        final int[] catchAllCount = new int[]{0};
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        FilteringOutboundRouter filterRouter1 = new FilteringOutboundRouter(){

            public MuleMessage route(MuleMessage message, MuleSession session) {
                count1[0] = count1[0] + 1;
                return message;
            }
        };
        FilteringOutboundRouter filterRouter2 = new FilteringOutboundRouter(){

            public MuleMessage route(MuleMessage message, MuleSession session) {
                count2[0] = count2[0] + 1;
                return message;
            }
        };
        filterRouter1.setFilter((Filter)new PayloadTypeFilter(Exception.class));
        filterRouter2.setFilter((Filter)new PayloadTypeFilter(StringBuffer.class));
        messageRouter.addRouter((Router)filterRouter1);
        messageRouter.addRouter((Router)filterRouter2);
        AbstractCatchAllStrategy strategy = new AbstractCatchAllStrategy(){

            public MuleMessage doCatchMessage(MuleMessage message, MuleSession session) {
                catchAllCount[0] = catchAllCount[0] + 1;
                return null;
            }
        };
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)strategy);
        MuleSession session = CatchAllStrategiesTestCase.getTestSession(CatchAllStrategiesTestCase.getTestService(), muleContext);
        messageRouter.route((MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext), session);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        CatchAllStrategiesTestCase.assertEquals((int)0, (int)count1[0]);
        CatchAllStrategiesTestCase.assertEquals((int)0, (int)count2[0]);
        messageRouter.route((MuleMessage)new DefaultMuleMessage((Object)new StringBuffer(), muleContext), session);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        CatchAllStrategiesTestCase.assertEquals((int)0, (int)count1[0]);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)count2[0]);
        messageRouter.route((MuleMessage)new DefaultMuleMessage((Object)new Exception(), muleContext), session);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)catchAllCount[0]);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)count1[0]);
        CatchAllStrategiesTestCase.assertEquals((int)1, (int)count2[0]);
    }

    private class TestEventTransformer
    extends AbstractTransformer {
        private TestEventTransformer() {
        }

        public Object doTransform(Object src, String encoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

