/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.RouterCatchAllStrategy;
import org.mule.api.routing.filter.Filter;
import org.mule.endpoint.DynamicURIOutboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ChainingRouter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class ChainingRouterTestCase
extends AbstractMuleTestCase {
    private Mock session;
    private ChainingRouter router;
    private List endpoints;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = MuleTestUtils.getMockSession();
        this.router = new ChainingRouter();
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((RouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = ChainingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test?synchronous=true");
        ChainingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = ChainingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test?synchronous=true");
        ChainingRouterTestCase.assertNotNull((Object)endpoint2);
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        this.router.setFilter((Filter)filter);
        this.endpoints = new ArrayList();
        this.endpoints.add(endpoint1);
        this.endpoints.add(endpoint2);
        this.router.setEndpoints(this.endpoints);
        ChainingRouterTestCase.assertEquals((Object)filter, (Object)this.router.getFilter());
        this.session.matchAndReturn("getService", (Object)ChainingRouterTestCase.getTestService("TEST", Object.class));
    }

    public void testChainingOutboundRouterSynchronous() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        ChainingRouterTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        message = new DefaultMuleMessage((Object)"test event", muleContext);
        this.session.expectAndReturn("sendEvent", C.eq((Object)message, this.endpoints.get(0)), (Object)message);
        this.session.expectAndReturn("sendEvent", C.eq((Object)message, this.endpoints.get(1)), (Object)message);
        MuleMessage result = this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        ChainingRouterTestCase.assertNotNull((String)"This is a sync call, we need a result returned.", (Object)result);
        ChainingRouterTestCase.assertEquals((Object)message, (Object)result);
        this.session.verify();
    }

    public void testChainingOutboundRouterSynchronousWithTemplate() throws Exception {
        OutboundEndpoint endpoint3 = ChainingRouterTestCase.getTestOutboundEndpoint("Test3Provider", "test://foo?[barValue]&synchronous=true");
        ChainingRouterTestCase.assertNotNull((Object)endpoint3);
        this.router.addEndpoint(endpoint3);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("barValue", "bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", m, muleContext);
        ChainingRouterTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        OutboundEndpoint ep = this.router.getEndpoint(2, (MuleMessage)message);
        ChainingRouterTestCase.assertEquals((String)"test://foo?bar&synchronous=true", (String)ep.getEndpointURI().toString());
        this.session.expectAndReturn("sendEvent", C.eq((Object)message, (Object)new DynamicURIOutboundEndpoint((OutboundEndpoint)this.router.getEndpoints().get(0), (EndpointURI)new MuleEndpointURI("test://test?synchronous=true", muleContext))), (Object)message);
        this.session.expectAndReturn("sendEvent", C.eq((Object)message, (Object)new DynamicURIOutboundEndpoint((OutboundEndpoint)this.router.getEndpoints().get(1), (EndpointURI)new MuleEndpointURI("test://test?synchronous=true", muleContext))), (Object)message);
        this.session.expectAndReturn("sendEvent", C.eq((Object)message, (Object)new DynamicURIOutboundEndpoint((OutboundEndpoint)this.router.getEndpoints().get(2), (EndpointURI)new MuleEndpointURI("test://foo?bar&synchronous=true", muleContext))), (Object)message);
        MuleMessage result = this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        ChainingRouterTestCase.assertNotNull((String)"This is a sync call, we need a result returned.", (Object)result);
        ChainingRouterTestCase.assertEquals((Object)message, (Object)result);
        this.session.verify();
    }

    public void testChainingOutboundRouterAsynchronous() throws Exception {
        OutboundEndpoint endpoint1 = ChainingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test");
        ChainingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = ChainingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test");
        ChainingRouterTestCase.assertNotNull((Object)endpoint2);
        this.endpoints.clear();
        this.endpoints.add(endpoint1);
        this.endpoints.add(endpoint2);
        this.router.setEndpoints(this.endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        ChainingRouterTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        message = new DefaultMuleMessage((Object)"test event", muleContext);
        this.session.expectAndReturn("sendEvent", C.eq((Object)message, this.endpoints.get(0)), (Object)message);
        this.session.expectAndReturn("dispatchEvent", C.eq((Object)message, this.endpoints.get(1)), (Object)message);
        MuleMessage result = this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        ChainingRouterTestCase.assertNull((String)"Async call shouldn't return any result.", (Object)result);
        this.session.verify();
    }

    public void testBrokenChain() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        ImmutableEndpoint endpoint1 = (ImmutableEndpoint)this.endpoints.get(0);
        this.session.expect("sendEvent", C.eq((Object)message, (Object)endpoint1));
        MuleMessage result = this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        this.session.verify();
        ChainingRouterTestCase.assertNull((Object)result);
    }
}

